/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.FunctionInvocation;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.ReferenceLookup;

public final class Decorator
extends GoloElement {
    private ExpressionStatement expressionStatement;
    private boolean constant = false;

    Decorator(ExpressionStatement expressionStatement) {
        this.setExpressionStatement(expressionStatement);
    }

    public ExpressionStatement getExpressionStatement() {
        return this.expressionStatement;
    }

    public void setExpressionStatement(ExpressionStatement expr) {
        if (!(expr instanceof ReferenceLookup) && !(expr instanceof FunctionInvocation)) {
            throw new IllegalArgumentException("Decorator expression must be a reference of a invocation");
        }
        this.expressionStatement = expr;
        this.makeParentOf(expr);
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public Decorator constant(boolean constant) {
        this.setConstant(constant);
        return this;
    }

    public Decorator constant() {
        return this.constant(true);
    }

    private ExpressionStatement wrapLookup(ReferenceLookup reference, ExpressionStatement expression) {
        return Builders.call(reference.getName()).constant(this.isConstant()).withArgs(expression);
    }

    private ExpressionStatement wrapInvocation(FunctionInvocation invocation, ExpressionStatement expression) {
        return invocation.followedBy(Builders.functionInvocation().constant(this.isConstant()).withArgs(expression));
    }

    public ExpressionStatement wrapExpression(ExpressionStatement expression) {
        if (this.expressionStatement instanceof ReferenceLookup) {
            return this.wrapLookup((ReferenceLookup)this.expressionStatement, expression);
        }
        return this.wrapInvocation((FunctionInvocation)this.expressionStatement, expression);
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitDecorator(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        this.expressionStatement.accept(visitor);
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!this.expressionStatement.equals(original) || !(newElement instanceof ExpressionStatement)) {
            throw this.cantReplace(original, newElement);
        }
        this.setExpressionStatement((ExpressionStatement)newElement);
    }
}

