/*
 * Decompiled with CFR 0.152.
 */
package gololang.concurrent.workers;

import gololang.FunctionReference;
import gololang.Predefined;
import gololang.concurrent.workers.Port;
import gololang.concurrent.workers.WorkerFunction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public final class WorkerEnvironment {
    private final ExecutorService executor;

    public WorkerEnvironment(ExecutorService executor) {
        this.executor = executor;
    }

    public static WorkerEnvironment newWorkerEnvironment() {
        return new WorkerEnvironment(Executors.newCachedThreadPool());
    }

    public static Builder builder() {
        return new Builder();
    }

    public Port spawn(FunctionReference func) {
        return this.spawnWorker((WorkerFunction)Predefined.asInterfaceInstance(WorkerFunction.class, func));
    }

    public Port spawnWorker(WorkerFunction function) {
        return new Port(this.executor, function);
    }

    public WorkerEnvironment shutdown() {
        this.executor.shutdown();
        return this;
    }

    public boolean awaitTermination(int millis) throws InterruptedException {
        return this.awaitTermination((long)millis);
    }

    public boolean awaitTermination(long millis) throws InterruptedException {
        return this.awaitTermination(millis, TimeUnit.MILLISECONDS);
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    public static class Builder {
        public WorkerEnvironment withCachedThreadPool() {
            return WorkerEnvironment.newWorkerEnvironment();
        }

        public WorkerEnvironment withFixedThreadPool(int size) {
            return new WorkerEnvironment(Executors.newFixedThreadPool(size));
        }

        public WorkerEnvironment withFixedThreadPool() {
            return this.withFixedThreadPool(Runtime.getRuntime().availableProcessors());
        }

        public WorkerEnvironment withSingleThreadExecutor() {
            return new WorkerEnvironment(Executors.newSingleThreadExecutor());
        }
    }
}

