/*
 * Decompiled with CFR 0.152.
 */
package gololang.concurrent.workers;

import gololang.concurrent.workers.WorkerFunction;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Port {
    private final ExecutorService executor;
    private final WorkerFunction function;
    private final ConcurrentLinkedQueue<Object> queue = new ConcurrentLinkedQueue();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Runnable runner = new Runnable(){

        @Override
        public void run() {
            if (Port.this.running.get()) {
                try {
                    Port.this.function.apply(Port.this.queue.poll());
                }
                finally {
                    Port.this.running.set(false);
                    Port.this.scheduleNext();
                }
            }
        }
    };

    public Port(ExecutorService executor, WorkerFunction function) {
        this.executor = executor;
        this.function = function;
    }

    private void scheduleNext() {
        if (!this.queue.isEmpty() && this.running.compareAndSet(false, true)) {
            try {
                this.executor.execute(this.runner);
            }
            catch (Throwable t) {
                this.running.set(false);
                throw t;
            }
        }
    }

    public Port send(Object message) {
        this.queue.offer(message);
        this.scheduleNext();
        return this;
    }
}

