/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.cli.command.spi.CliCommand;

@Parameters(commandNames={"run"}, commandDescription="Runs compiled Golo code")
public class RunCommand
implements CliCommand {
    @Parameter(names={"--module"}, description="The Golo module with a main function", required=true)
    String module;
    @Parameter(description="Program arguments")
    List<String> arguments = new LinkedList<String>();
    @Parameter(names={"--classpath"}, variableArity=true, description="Classpath elements (.jar and directories)")
    List<String> classpath = new LinkedList<String>();

    @Override
    public void execute() throws Throwable {
        try {
            this.classpath.add(".");
            URLClassLoader primaryClassLoader = this.primaryClassLoader(this.classpath);
            Thread.currentThread().setContextClassLoader(primaryClassLoader);
            Class<?> module = Class.forName(this.module, true, primaryClassLoader);
            this.callRun(module, this.arguments.toArray(new String[this.arguments.size()]));
        }
        catch (ClassNotFoundException e) {
            System.out.println("The module " + this.module + " could not be loaded.");
        }
        catch (NoSuchMethodException e) {
            System.out.println("The module " + this.module + " does not have a main method with an argument.");
        }
    }
}

