/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.naming.Context;
import org.glassfish.grizzly.http.server.naming.DirContext;
import org.glassfish.grizzly.http.server.naming.NamingContext;
import org.glassfish.grizzly.http.server.naming.NamingException;

public class ContextsAdapterUtility {
    public static NamingContext wrap(Context namingContext) {
        if (namingContext == null) {
            return null;
        }
        return new NamingContextAdapter(namingContext);
    }

    public static Context unwrap(NamingContext grizzlyNamingContext) {
        if (grizzlyNamingContext == null) {
            return null;
        }
        if (!(grizzlyNamingContext instanceof NamingContextAdapter)) {
            throw new IllegalArgumentException("Unknown NamingContext type: " + grizzlyNamingContext.getClass().getName());
        }
        return ((NamingContextAdapter)grizzlyNamingContext).getJmxNamingContext();
    }

    public static DirContext wrap(javax.naming.directory.DirContext dirContext) {
        if (dirContext == null) {
            return null;
        }
        return new DirContextAdapter(dirContext);
    }

    public static javax.naming.directory.DirContext unwrap(DirContext grizzlyDirContext) {
        if (grizzlyDirContext == null) {
            return null;
        }
        if (!(grizzlyDirContext instanceof DirContextAdapter)) {
            throw new IllegalArgumentException("Unknown DirContext type: " + grizzlyDirContext.getClass().getName());
        }
        return ((DirContextAdapter)grizzlyDirContext).getJmxDirContext();
    }

    private static Object wrapIfNeeded(Object resource) {
        if (resource == null) {
            return null;
        }
        if (resource instanceof javax.naming.directory.DirContext) {
            return ContextsAdapterUtility.wrap((javax.naming.directory.DirContext)resource);
        }
        if (resource instanceof Context) {
            return ContextsAdapterUtility.wrap((Context)resource);
        }
        return resource;
    }

    private static class DirContextAdapter
    implements DirContext {
        private final javax.naming.directory.DirContext jmxDirContext;

        private DirContextAdapter(javax.naming.directory.DirContext jmxDirContext) {
            this.jmxDirContext = jmxDirContext;
        }

        public javax.naming.directory.DirContext getJmxDirContext() {
            return this.jmxDirContext;
        }

        public Object lookup(String pathStr) throws NamingException {
            try {
                return ContextsAdapterUtility.wrapIfNeeded(this.jmxDirContext.lookup(pathStr));
            }
            catch (javax.naming.NamingException e) {
                throw new NamingException((Throwable)e);
            }
        }
    }

    private static class NamingContextAdapter
    implements DirContext {
        private final Context jmxNamingContext;

        private NamingContextAdapter(Context jmxNamingContext) {
            this.jmxNamingContext = jmxNamingContext;
        }

        public Context getJmxNamingContext() {
            return this.jmxNamingContext;
        }

        public Object lookup(String pathStr) throws NamingException {
            try {
                return ContextsAdapterUtility.wrapIfNeeded(this.jmxNamingContext.lookup(pathStr));
            }
            catch (javax.naming.NamingException e) {
                throw new NamingException((Throwable)e);
            }
        }
    }
}

