/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.DigestEncoder;

public class DigestAuthenticator
extends AuthenticatorBase {
    protected static final DigestEncoder digestEncoder = new DigestEncoder();
    protected static final String info = "org.apache.catalina.authenticator.DigestAuthenticator/1.0";
    protected static final String QOP = "auth";
    protected static final String DEFAULT_ALGORITHM = "MD5";
    private static final String EMPTY_STRING = "";
    protected static volatile String algorithm = "MD5";
    protected static volatile MessageDigest messageDigest;
    protected int cnonceCacheSize = 1000;
    protected String key = null;
    protected long nonceValidity = 300000L;
    protected String opaque;
    protected boolean validateUri = true;

    public static String getAlgorithm() {
        return algorithm;
    }

    public static synchronized void setAlgorithm(String alg) {
        algorithm = alg;
        messageDigest = null;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public int getCnonceCacheSize() {
        return this.cnonceCacheSize;
    }

    public void setCnonceCacheSize(int cnonceCacheSize) {
        this.cnonceCacheSize = cnonceCacheSize;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public long getNonceValidity() {
        return this.nonceValidity;
    }

    public void setNonceValidity(long nonceValidity) {
        this.nonceValidity = nonceValidity;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    public boolean isValidateUri() {
        return this.validateUri;
    }

    public void setValidateUri(boolean validateUri) {
        this.validateUri = validateUri;
    }

    @Override
    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        boolean validRequest;
        Principal principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal();
        if (principal != null) {
            return true;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        String authorization = request.getAuthorization();
        DigestInfo digestInfo = new DigestInfo(this.getOpaque(), this.getNonceValidity(), this.getKey(), this.isValidateUri());
        if (authorization != null && (validRequest = digestInfo.validate(hreq, authorization, config)) && (principal = this.context.getRealm().authenticate(hreq)) != null) {
            String username = this.parseUsername(authorization);
            this.register(request, response, principal, "DIGEST", username, null);
            String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
            if (ssoId != null) {
                this.getSession(request, true);
            }
            return true;
        }
        String nonce = this.generateNonce(hreq);
        this.setAuthenticateHeader(hreq, hres, config, nonce, digestInfo.isNonceStale());
        hres.sendError(401);
        return false;
    }

    protected String parseUsername(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        authorization = authorization.substring(7).trim();
        StringTokenizer commaTokenizer = new StringTokenizer(authorization, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String currentToken = commaTokenizer.nextToken();
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if (!"username".equals(currentTokenName)) continue;
            return DigestAuthenticator.removeQuotes(currentTokenValue);
        }
        return null;
    }

    @Override
    protected String getAuthMethod() {
        return "DIGEST";
    }

    protected static String removeQuotes(String quotedString, boolean quotesRequired) {
        if (quotedString.length() > 0 && quotedString.charAt(0) != '\"' && !quotesRequired) {
            return quotedString;
        }
        if (quotedString.length() > 2) {
            return quotedString.substring(1, quotedString.length() - 1);
        }
        return EMPTY_STRING;
    }

    protected static String removeQuotes(String quotedString) {
        return DigestAuthenticator.removeQuotes(quotedString, false);
    }

    protected String generateNonce(HttpServletRequest request) {
        long currentTime = System.currentTimeMillis();
        String ipTimeKey = request.getRemoteAddr() + ":" + currentTime + ":" + this.getKey();
        byte[] buffer = DigestAuthenticator.digest(ipTimeKey.getBytes(Charset.defaultCharset()));
        return currentTime + ":" + new String(digestEncoder.encode(buffer));
    }

    protected void setAuthenticateHeader(HttpServletRequest request, HttpServletResponse response, LoginConfig config, String nOnce, boolean isNonceStale) {
        String realmName = config.getRealmName();
        if (realmName == null) {
            realmName = "Authentication required";
        }
        String authenticateHeader = isNonceStale ? "Digest realm=\"" + realmName + "\", qop=\"" + QOP + "\", nonce=\"" + nOnce + "\", opaque=\"" + this.getOpaque() + "\", stale=true" : "Digest realm=\"" + realmName + "\", qop=\"" + QOP + "\", nonce=\"" + nOnce + "\", opaque=\"" + this.getOpaque() + "\"";
        response.setHeader("WWW-Authenticate", authenticateHeader);
    }

    protected static synchronized MessageDigest getMessageDigest() {
        if (messageDigest == null) {
            try {
                messageDigest = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(algorithm + " digest algorithm not available", e);
            }
        }
        return messageDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] digest(byte[] data) {
        MessageDigest md;
        byte[] buffer = null;
        MessageDigest messageDigest = md = DigestAuthenticator.getMessageDigest();
        synchronized (messageDigest) {
            buffer = md.digest(data);
        }
        return buffer;
    }

    @Override
    public synchronized void start() throws LifecycleException {
        super.start();
        if (this.getKey() == null) {
            this.setKey(this.generateSessionId());
        }
        if (this.getOpaque() == null) {
            this.setOpaque(this.generateSessionId());
        }
    }

    private static class DigestInfo {
        private String opaque;
        private long nonceValidity;
        private String key;
        private boolean validateUri = true;
        private String userName = null;
        private String uri = null;
        private String response = null;
        private String nonce = null;
        private String nc = null;
        private String cnonce = null;
        private String realmName = null;
        private String qop = null;
        private boolean nonceStale = false;

        public DigestInfo(String opaque, long nonceValidity, String key, boolean validateUri) {
            this.opaque = opaque;
            this.nonceValidity = nonceValidity;
            this.key = key;
            this.validateUri = validateUri;
        }

        public boolean validate(HttpServletRequest request, String authorization, LoginConfig config) {
            long nOnceTime;
            String query;
            String uriQuery;
            if (authorization == null) {
                return false;
            }
            if (!authorization.startsWith("Digest ")) {
                return false;
            }
            authorization = authorization.substring(7).trim();
            String[] tokens = authorization.split(",(?=(?:[^\"]*\"[^\"]*\")+$)");
            String opaque_client = null;
            for (int i = 0; i < tokens.length; ++i) {
                String currentToken = tokens[i];
                if (currentToken.length() == 0) continue;
                int equalSign = currentToken.indexOf(61);
                if (equalSign < 0) {
                    return false;
                }
                String currentTokenName = currentToken.substring(0, equalSign).trim();
                String currentTokenValue = currentToken.substring(equalSign + 1).trim();
                if ("username".equals(currentTokenName)) {
                    this.userName = DigestAuthenticator.removeQuotes(currentTokenValue);
                }
                if ("realm".equals(currentTokenName)) {
                    this.realmName = DigestAuthenticator.removeQuotes(currentTokenValue, true);
                }
                if ("nonce".equals(currentTokenName)) {
                    this.nonce = DigestAuthenticator.removeQuotes(currentTokenValue);
                }
                if ("nc".equals(currentTokenName)) {
                    this.nc = DigestAuthenticator.removeQuotes(currentTokenValue);
                }
                if ("cnonce".equals(currentTokenName)) {
                    this.cnonce = DigestAuthenticator.removeQuotes(currentTokenValue);
                }
                if ("qop".equals(currentTokenName)) {
                    this.qop = DigestAuthenticator.removeQuotes(currentTokenValue);
                }
                if ("uri".equals(currentTokenName)) {
                    this.uri = DigestAuthenticator.removeQuotes(currentTokenValue);
                }
                if ("response".equals(currentTokenName)) {
                    this.response = DigestAuthenticator.removeQuotes(currentTokenValue);
                }
                if (!"opaque".equals(currentTokenName)) continue;
                opaque_client = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if (this.userName == null || this.realmName == null || this.nonce == null || this.uri == null || this.response == null) {
                return false;
            }
            if (this.validateUri && !this.uri.equals(uriQuery = (query = request.getQueryString()) == null ? request.getRequestURI() : request.getRequestURI() + "?" + query)) {
                return false;
            }
            String lcRealm = config.getRealmName();
            if (lcRealm == null) {
                lcRealm = "Authentication required";
            }
            if (!lcRealm.equals(this.realmName)) {
                return false;
            }
            if (!this.opaque.equals(opaque_client)) {
                return false;
            }
            int i = this.nonce.indexOf(":");
            if (i < 0 || i + 1 == this.nonce.length()) {
                return false;
            }
            try {
                nOnceTime = Long.parseLong(this.nonce.substring(0, i));
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            String md5clientIpTimeKey = this.nonce.substring(i + 1);
            long currentTime = System.currentTimeMillis();
            if (currentTime - nOnceTime > this.nonceValidity) {
                this.nonceStale = true;
                return false;
            }
            String serverIpTimeKey = request.getRemoteAddr() + ":" + nOnceTime + ":" + this.key;
            byte[] buffer = DigestAuthenticator.digest(serverIpTimeKey.getBytes(Charset.defaultCharset()));
            String md5ServerIpTimeKey = new String(digestEncoder.encode(buffer));
            if (!md5ServerIpTimeKey.equals(md5clientIpTimeKey)) {
                return false;
            }
            if (this.qop != null && !DigestAuthenticator.QOP.equals(this.qop)) {
                return false;
            }
            if (this.qop == null) {
                if (this.cnonce != null || this.nc != null) {
                    return false;
                }
            } else {
                if (this.cnonce == null || this.nc == null) {
                    return false;
                }
                if (this.nc.length() != 8) {
                    return false;
                }
                try {
                    Long.parseLong(this.nc, 16);
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            return true;
        }

        public boolean isNonceStale() {
            return this.nonceStale;
        }
    }
}

