/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import javax.faces.context.FacesContext;
import javax.servlet.http.Cookie;

public class CookieUtils {
    private static final char[] badCookieChars = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\'', '/', '[', ']', '?', '=', '{', '}', ' ', '\t'};

    public static Cookie getCookieValue(FacesContext context, String name) {
        name = CookieUtils.getValidCookieName(name);
        return (Cookie)context.getExternalContext().getRequestCookieMap().get(name);
    }

    public static void setCookieValue(FacesContext context, String name, String value) {
        name = CookieUtils.getValidCookieName(name);
        context.getExternalContext().getRequestCookieMap().put(name, value);
    }

    public static String getValidCookieName(String name) {
        for (char ch : badCookieChars) {
            name = name.replace(ch, '_');
        }
        return name;
    }
}

