/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataListener;
import com.sun.data.provider.DataProvider;
import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.TransactionalDataListener;
import com.sun.data.provider.TransactionalDataProvider;
import com.sun.data.provider.impl.AbstractDataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;

public class BasicTransactionalDataProvider
extends AbstractDataProvider
implements TransactionalDataProvider {
    private transient ResourceBundle bundle = null;
    protected DataProvider provider;
    protected HashMap changeMap = new HashMap();
    protected DataListener ears = new DataListener(){

        public void valueChanged(DataProvider provider, FieldKey fieldKey, Object oldValue, Object newValue) {
            BasicTransactionalDataProvider.this.fireValueChanged(fieldKey, oldValue, newValue);
        }

        public void providerChanged(DataProvider provider) {
            BasicTransactionalDataProvider.this.fireProviderChanged();
        }
    };

    public void setDataProvider(DataProvider provider) {
        if (this.provider != null) {
            this.provider.removeDataListener(this.ears);
        }
        this.provider = provider;
        this.provider.addDataListener(this.ears);
        this.changeMap.clear();
        this.fireProviderChanged();
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com/sun/data/provider/impl/Bundle");
        }
        return this.bundle;
    }

    public DataProvider getDataProvider() {
        return this.provider;
    }

    public FieldKey[] getFieldKeys() throws DataProviderException {
        if (this.provider == null) {
            return FieldKey.EMPTY_ARRAY;
        }
        return this.provider.getFieldKeys();
    }

    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        if (this.provider == null) {
            throw new DataProviderException(this.getBundle().getString("NO_DATAPROVIDER_SET"));
        }
        return this.provider.getFieldKey(fieldId);
    }

    public Class getType(FieldKey fieldKey) throws DataProviderException {
        if (this.provider == null) {
            throw new DataProviderException(this.getBundle().getString("arbitraryCharData"));
        }
        return this.provider.getType(fieldKey);
    }

    public Object getValue(FieldKey fieldKey) throws DataProviderException {
        if (this.provider == null) {
            throw new DataProviderException(this.getBundle().getString("NO_DATAPROVIDER_SET"));
        }
        if (this.changeMap.containsKey(fieldKey)) {
            return this.changeMap.get(fieldKey);
        }
        return this.provider.getValue(fieldKey);
    }

    public boolean isReadOnly(FieldKey fieldKey) throws DataProviderException {
        if (this.provider == null) {
            throw new DataProviderException(this.getBundle().getString("NO_DATAPROVIDER_SET"));
        }
        return this.provider.isReadOnly(fieldKey);
    }

    public void setValue(FieldKey fieldKey, Object value) throws DataProviderException {
        if (this.provider == null) {
            throw new DataProviderException(this.getBundle().getString("NO_DATAPROVIDER_SET"));
        }
        if (this.provider.isReadOnly(fieldKey)) {
            throw new DataProviderException(this.getBundle().getString("FK_READ_ONLY"));
        }
        Object oldValue = this.getValue(fieldKey);
        this.changeMap.put(fieldKey, value);
        this.fireValueChanged(fieldKey, oldValue, value);
    }

    public void commitChanges() throws DataProviderException {
        Iterator i = this.changeMap.keySet().iterator();
        while (i.hasNext()) {
            FieldKey key = (FieldKey)i.next();
            this.provider.setValue(key, this.changeMap.get(key));
        }
        this.changeMap.clear();
        this.fireChangesCommitted();
    }

    public void revertChanges() throws DataProviderException {
        this.changeMap.clear();
        this.fireChangesReverted();
        this.fireProviderChanged();
    }

    public void addTransactionalDataListener(TransactionalDataListener l) {
        super.addDataListener(l);
    }

    public void removeTransactionalDataListener(TransactionalDataListener l) {
        super.removeDataListener(l);
    }

    public TransactionalDataListener[] getTransactionalDataListeners() {
        if (this.dpListeners == null) {
            return new TransactionalDataListener[0];
        }
        ArrayList<DataListener> cdpList = new ArrayList<DataListener>();
        for (int i = 0; i < this.dpListeners.length; ++i) {
            if (!(this.dpListeners[i] instanceof TransactionalDataListener)) continue;
            cdpList.add(this.dpListeners[i]);
        }
        return cdpList.toArray(new TransactionalDataListener[cdpList.size()]);
    }

    protected void fireChangesCommitted() {
        TransactionalDataListener[] cdls = this.getTransactionalDataListeners();
        for (int i = 0; i < cdls.length; ++i) {
            cdls[i].changesCommitted(this);
        }
    }

    protected void fireChangesReverted() {
        TransactionalDataListener[] cdls = this.getTransactionalDataListeners();
        for (int i = 0; i < cdls.length; ++i) {
            cdls[i].changesReverted(this);
        }
    }
}

