/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.custom;

import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.features.custom.FMCCustomFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class UnhideContentCustomFeature
extends FMCCustomFeature {
    private boolean hasDoneChanges = false;

    public UnhideContentCustomFeature(IFeatureProvider featureProvider) {
        super(featureProvider, "Transform");
    }

    public String getName() {
        return "Show Content";
    }

    public String getImageId() {
        return "org.eclipse.fmc.ShowContent_16";
    }

    public String getDescription() {
        return "Unhide the contained elements";
    }

    public boolean canExecute(ICustomContext context) {
        boolean ret = false;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && context.getPictogramElements()[0] instanceof ContainerShape) {
            ContainerShape container = (ContainerShape)context.getPictogramElements()[0];
            FMCNodeAlgorithm na = FMCNodeAlgorithmFactory.getInstance().getShape((PictogramElement)container);
            ret = na != null && !na.isEmpty(container) && na.isHiding(container);
        }
        return ret;
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            ContainerShape firstLevelContainer = (ContainerShape)context.getPictogramElements()[0];
            FMCNodeAlgorithm na = FMCNodeAlgorithmFactory.getInstance().getShape((PictogramElement)firstLevelContainer);
            na.hideContainedShapes(firstLevelContainer, false);
        }
    }

    public boolean hasDoneChanges() {
        return this.hasDoneChanges;
    }
}

