/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.resize;

import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.features.resize.ResizeFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class ContainerResizeFeature
extends ResizeFeature {
    private FMCNodeAlgorithm fmcNode;

    public ContainerResizeFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public final void resizeShape(IResizeShapeContext context) {
        GraphicsAlgorithm resizeGa = context.getPictogramElement().getGraphicsAlgorithm();
        this.fmcNode = FMCNodeAlgorithmFactory.getInstance().getShape(context.getPictogramElement());
        if (this.fmcNode != null) {
            int oldContainerWidth = resizeGa.getWidth();
            int oldContainerHeight = resizeGa.getHeight();
            int oldContainerX = resizeGa.getX();
            int oldContainerY = resizeGa.getY();
            int newContainerWidth = context.getWidth();
            int newContainerHeight = context.getHeight();
            int newContainerX = context.getX();
            int newContainerY = context.getY();
            if (context.getWidth() < this.fmcNode.getMinimumWidth()) {
                if (oldContainerX != context.getX()) {
                    newContainerX = oldContainerX + oldContainerWidth - this.fmcNode.getMinimumWidth();
                }
                newContainerWidth = this.fmcNode.getMinimumWidth();
            }
            if (context.getHeight() < this.fmcNode.getMinimumHeight()) {
                if (oldContainerY != context.getY()) {
                    newContainerY = oldContainerY + oldContainerHeight - this.fmcNode.getMinimumHeight();
                }
                newContainerHeight = this.fmcNode.getMinimumHeight();
            }
            this.fmcNode.resize(resizeGa, newContainerX, newContainerY, newContainerWidth, newContainerHeight);
            if (context.getPictogramElement() instanceof ContainerShape) {
                for (GraphicsAlgorithm childGa : resizeGa.getGraphicsAlgorithmChildren()) {
                    this.resizeGaChild(childGa, newContainerWidth - oldContainerWidth, newContainerHeight - oldContainerHeight);
                }
            }
        } else {
            super.resizeShape(context);
        }
    }

    private void resizeGaChild(GraphicsAlgorithm ga, int widthDelta, int heightDelta) {
        int oldWidth = ga.getWidth();
        int oldHeight = ga.getHeight();
        this.fmcNode.resize(ga, ga.getX(), ga.getY(), oldWidth + widthDelta, oldHeight + heightDelta);
        for (GraphicsAlgorithm childGa : ga.getGraphicsAlgorithmChildren()) {
            this.resizeGaChild(childGa, widthDelta, heightDelta);
        }
    }

    private boolean isDirectGraphicsContainer(Shape shape) {
        return !shape.isActive() && !(shape.getGraphicsAlgorithm() instanceof MultiText);
    }

    protected void resizeChild(ContainerShape container, IResizeShapeContext context) {
        super.resizeShape(context);
    }

    protected int getMaximumChildWidth(ContainerShape shape) {
        int max = 0;
        for (Shape child : shape.getChildren()) {
            if (this.isDirectGraphicsContainer(child) || max >= child.getGraphicsAlgorithm().getWidth()) continue;
            max = child.getGraphicsAlgorithm().getWidth();
        }
        return max;
    }

    protected int getMaximumChildHeight(ContainerShape shape) {
        int max = 0;
        for (Shape child : shape.getChildren()) {
            if (this.isDirectGraphicsContainer(child) || max >= child.getGraphicsAlgorithm().getHeight()) continue;
            max = child.getGraphicsAlgorithm().getHeight();
        }
        return max;
    }
}

