/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.add;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fmc.blockdiagram.editor.features.add.AgentAddFeature;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.StyleContainer;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class BlockDiagramAddFeature
extends AgentAddFeature {
    public static final String DIAGRAM_PROP = "RES";

    public BlockDiagramAddFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public PictogramElement add(IAddContext context) {
        ContainerShape container = context.getTargetContainer();
        Diagram blockDiagram = (Diagram)context.getProperty((Object)DIAGRAM_PROP);
        blockDiagram = (Diagram)EcoreUtil.copy((EObject)blockDiagram);
        for (Shape shape : new ArrayList(blockDiagram.getChildren())) {
            shape.setContainer(container);
        }
        for (Connection con : new ArrayList(blockDiagram.getConnections())) {
            con.setParent(this.getDiagram());
            if (!(con instanceof FreeFormConnection)) continue;
            ILocation locationRelativeToDiagram = Graphiti.getPeLayoutService().getLocationRelativeToDiagram((Shape)container);
            for (Point bend : ((FreeFormConnection)con).getBendpoints()) {
                bend.setX(bend.getX() + locationRelativeToDiagram.getX());
                bend.setY(bend.getY() + locationRelativeToDiagram.getY());
            }
        }
        for (Style style : new ArrayList(blockDiagram.getStyles())) {
            style.setStyleContainer((StyleContainer)this.getDiagram());
            this.getDiagram().getStyles().add((Object)style);
        }
        for (Font font : new ArrayList(blockDiagram.getFonts())) {
            this.getDiagram().getFonts().add((Object)font);
        }
        for (Color color : new ArrayList(blockDiagram.getColors())) {
            this.getDiagram().getColors().add((Object)color);
        }
        return blockDiagram;
    }
}

