/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IMultiDeleteInfo;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;

public class DontAskWhenDeleteFeature
extends DefaultDeleteFeature {
    private boolean dirty;

    public DontAskWhenDeleteFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
    }

    public boolean canDelete(IDeleteContext context) {
        return !(context.getPictogramElement() instanceof Diagram);
    }

    public void delete(IDeleteContext context) {
        IMultiDeleteInfo multiDeleteInfo = context.getMultiDeleteInfo();
        if (multiDeleteInfo != null && multiDeleteInfo.isDeleteCanceled()) {
            return;
        }
        PictogramElement pe = context.getPictogramElement();
        Object[] businessObjectsForPictogramElement = this.getAllBusinessObjectsForPictogramElement(pe);
        if (businessObjectsForPictogramElement != null && businessObjectsForPictogramElement.length > 0) {
            if (multiDeleteInfo == null) {
                if (!this.getUserDecision(context)) {
                    return;
                }
            } else if (multiDeleteInfo.isShowDialog()) {
                boolean okPressed = this.getUserDecision(context);
                if (okPressed) {
                    multiDeleteInfo.setShowDialog(false);
                } else {
                    multiDeleteInfo.setDeleteCanceled(true);
                    return;
                }
            }
        }
        this.dirty = true;
        this.preDelete(context);
        RemoveContext rc = new RemoveContext(pe);
        IFeatureProvider featureProvider = this.getFeatureProvider();
        DefaultRemoveFeature removeFeature = new DefaultRemoveFeature(featureProvider);
        if (removeFeature != null) {
            removeFeature.remove((IRemoveContext)rc);
        }
        this.deleteBusinessObjects(businessObjectsForPictogramElement);
        this.postDelete(context);
    }

    public boolean hasDoneChanges() {
        return this.dirty;
    }

    protected void setDoneChanges(boolean doneChanges) {
        this.dirty = doneChanges;
    }

    protected boolean getUserDecision(IDeleteContext context) {
        return true;
    }
}

