/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.algorithm.node;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.AgentAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.HumanAgentAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.LAgentAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.LStorageAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.RectangleAgentAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.RectangleStorageAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.StorageAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.UAgentAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.UStorageAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeChecker;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeCheckerFactory;
import org.eclipse.fmc.blockdiagram.editor.model.ShapeStyle;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class FMCNodeAlgorithmFactory {
    private static FMCNodeAlgorithmFactory instance;
    private FMCTypeChecker helper = FMCTypeCheckerFactory.getInstance();
    private RectangleStorageAlgorithm storage = null;
    private HumanAgentAlgorithm humanAgent = null;
    private RectangleAgentAlgorithm agent = null;
    private LAgentAlgorithm lAgent = null;
    private UAgentAlgorithm uAgent = null;
    private LStorageAlgorithm lStorage = null;
    private UStorageAlgorithm uStorage = null;

    private FMCNodeAlgorithmFactory() {
    }

    public static synchronized FMCNodeAlgorithmFactory getInstance() {
        if (instance == null) {
            instance = new FMCNodeAlgorithmFactory();
        }
        return instance;
    }

    private RectangleAgentAlgorithm getAgent() {
        if (this.agent == null) {
            this.agent = new RectangleAgentAlgorithm();
        }
        return this.agent;
    }

    public HumanAgentAlgorithm getHumanAgent() {
        if (this.humanAgent == null) {
            this.humanAgent = new HumanAgentAlgorithm();
        }
        return this.humanAgent;
    }

    private RectangleStorageAlgorithm getStorage() {
        if (this.storage == null) {
            this.storage = new RectangleStorageAlgorithm();
        }
        return this.storage;
    }

    private RectangleStorageAlgorithm getStructureVariance() {
        if (this.storage == null) {
            this.storage = new RectangleStorageAlgorithm();
        }
        return this.storage;
    }

    private LAgentAlgorithm getLAgent() {
        if (this.lAgent == null) {
            this.lAgent = new LAgentAlgorithm();
        }
        return this.lAgent;
    }

    private UAgentAlgorithm getUAgent() {
        if (this.uAgent == null) {
            this.uAgent = new UAgentAlgorithm();
        }
        return this.uAgent;
    }

    private LStorageAlgorithm getLStorage() {
        if (this.lStorage == null) {
            this.lStorage = new LStorageAlgorithm();
        }
        return this.lStorage;
    }

    private UStorageAlgorithm getUStorage() {
        if (this.uStorage == null) {
            this.uStorage = new UStorageAlgorithm();
        }
        return this.uStorage;
    }

    public AgentAlgorithm getAgentByShapestyle(ShapeStyle style) {
        switch (style) {
            case L: {
                return this.getLAgent();
            }
            case U: {
                return this.getUAgent();
            }
        }
        return this.getAgent();
    }

    public StorageAlgorithm getStorageByShapestyle(ShapeStyle style) {
        switch (style) {
            case L: {
                return this.getLStorage();
            }
            case U: {
                return this.getUStorage();
            }
        }
        return this.getStorage();
    }

    public FMCNodeAlgorithm getShape(PictogramElement picto) {
        if (this.isAgentWithStyle(picto, ShapeStyle.L)) {
            return this.getLAgent();
        }
        if (this.isAgentWithStyle(picto, ShapeStyle.U)) {
            return this.getUAgent();
        }
        if (this.helper.isHumanAgent(picto)) {
            return this.getHumanAgent();
        }
        if (this.helper.isAgent(picto)) {
            return this.getAgent();
        }
        if (this.isStorageWithStyle(picto, ShapeStyle.L)) {
            return this.getLStorage();
        }
        if (this.isStorageWithStyle(picto, ShapeStyle.U)) {
            return this.getUStorage();
        }
        if (this.helper.isStorage(picto)) {
            return this.getStorage();
        }
        if (this.helper.isStructureVariance(picto)) {
            return this.getStructureVariance();
        }
        return null;
    }

    private boolean isAgentWithStyle(PictogramElement picto, ShapeStyle style) {
        if (!this.helper.isAgent(picto)) {
            return false;
        }
        if (style != ShapeStyle.RECT && picto.getGraphicsAlgorithm() instanceof Polygon) {
            Polygon polygon = (Polygon)picto.getGraphicsAlgorithm();
            EList points = polygon.getPoints();
            if (style == ShapeStyle.L && points.size() == 6) {
                return true;
            }
            if (style == ShapeStyle.U && points.size() == 8) {
                return true;
            }
        } else if (style == ShapeStyle.RECT) {
            return this.helper.isAgent(picto);
        }
        return false;
    }

    private boolean isStorageWithStyle(PictogramElement picto, ShapeStyle style) {
        if (!this.helper.isStorage(picto)) {
            return false;
        }
        if (style != ShapeStyle.RECT && picto.getGraphicsAlgorithm() instanceof Polygon) {
            Polygon polygon = (Polygon)picto.getGraphicsAlgorithm();
            EList points = polygon.getPoints();
            if (style == ShapeStyle.L && points.size() == 6) {
                return true;
            }
            if (style == ShapeStyle.U && points.size() == 8) {
                return true;
            }
        } else if (style == ShapeStyle.RECT) {
            return this.helper.isStorage(picto);
        }
        return false;
    }
}

