/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.add;

import org.eclipse.fmc.blockdiagram.editor.algorithm.comment.BraceAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.comment.CommentAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.features.add.ShapeAddFeature;
import org.eclipse.fmc.blockdiagram.editor.util.StyleUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class BraceAddFeature
extends ShapeAddFeature {
    private BraceAlgorithm braceAlgorithm = CommentAlgorithmFactory.getInstance().getBrace();

    public BraceAddFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
        this.minimumWidth = this.braceAlgorithm.getMinimumWidth();
        this.minimumHeight = this.braceAlgorithm.getMinimumHeight();
    }

    public BraceAddFeature(IFeatureProvider featureProvider, boolean linked) {
        super(featureProvider);
        this.minimumWidth = this.braceAlgorithm.getMinimumWidth();
        this.minimumHeight = this.braceAlgorithm.getMinimumHeight();
        this.linked = linked;
    }

    @Override
    public boolean canAdd(IAddContext context) {
        return true;
    }

    public PictogramElement add(IAddContext context) {
        ContainerShape container = context.getTargetContainer();
        ContainerShape newContainer = this.pe.createContainerShape(container, true);
        Rectangle invRec = this.ga.createInvisibleRectangle((PictogramElement)newContainer);
        invRec.setStyle(StyleUtil.getStyle(this.getDiagram(), "Shape"));
        if (this.linked) {
            this.link((PictogramElement)newContainer, context.getNewObject());
        }
        BraceAlgorithm algorithm = CommentAlgorithmFactory.getInstance().getBrace();
        GraphicsAlgorithm secondLevelGa = algorithm.createGraphics(this.getDiagram(), (GraphicsAlgorithmContainer)invRec, context.getX(), context.getY(), this.getWidth(context), this.getHeight(context));
        secondLevelGa.setParentGraphicsAlgorithm((GraphicsAlgorithm)invRec);
        return newContainer;
    }
}

