/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.algorithm.node;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.AbstractNode;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.PolygonAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.util.StyleUtil;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.Shape;

public abstract class AbstractPolygonAlgorithm
extends AbstractNode
implements PolygonAlgorithm {
    public Polygon createGraphics(Diagram diagram, GraphicsAlgorithmContainer container, int x, int y, int width, int height) {
        Polygon polygon = this.ga.createPolygon(container, this.getInitialPoints(0, 0, width, height));
        this.ga.setLocationAndSize((GraphicsAlgorithm)polygon, x, y, width, height);
        polygon.setLineWidth(Integer.valueOf(3));
        polygon.setTransparency(null);
        polygon.setStyle(StyleUtil.getStyle(diagram, "Shape"));
        if (container instanceof GraphicsAlgorithm) {
            ContainerShape containerShape = this.getContainerShape((GraphicsAlgorithm)polygon);
            this.pe.createChopboxAnchor((AnchorContainer)containerShape);
            this.createBoxAnchorSet((Shape)containerShape);
        }
        return polygon;
    }

    @Override
    public boolean hasRoundedCorners() {
        return false;
    }

    @Override
    public void synchronizeFirstLevelShape(ContainerShape firstLevelContainer) {
        Polygon firstLevelPolygon = (Polygon)firstLevelContainer.getGraphicsAlgorithm();
        Polygon secondLevelPolygon = this.isMultipleInstances(firstLevelContainer) ? (Polygon)this.getMultiInstanceChild(firstLevelContainer, true) : (Polygon)firstLevelPolygon.getGraphicsAlgorithmChildren().get(0);
        int w = firstLevelPolygon.getWidth();
        int h = firstLevelPolygon.getHeight();
        int i = 0;
        for (Point secondLevelPoint : secondLevelPolygon.getPoints()) {
            Point firstLevelPoint = (Point)firstLevelPolygon.getPoints().get(i++);
            if (secondLevelPoint.getX() != w - 5) {
                firstLevelPoint.setX(secondLevelPoint.getX());
            } else {
                firstLevelPoint.setX(w);
            }
            if (secondLevelPoint.getY() != h - 5) {
                firstLevelPoint.setY(secondLevelPoint.getY());
            } else {
                firstLevelPoint.setY(h);
            }
            firstLevelPoint.setAfter(secondLevelPoint.getAfter());
            firstLevelPoint.setBefore(secondLevelPoint.getBefore());
        }
    }

    @Override
    public void rotate90Right(GraphicsAlgorithm graphicsAlgorithm) {
        Polygon polygon = (Polygon)graphicsAlgorithm;
        polygon.setX(polygon.getX() + (polygon.getWidth() - polygon.getHeight()) / 2);
        polygon.setY(polygon.getY() - (polygon.getWidth() - polygon.getHeight()) / 2);
        this.doRotate(polygon);
    }

    private void doRotate(Polygon polygon) {
        int oldWidth = polygon.getWidth();
        int oldHeight = polygon.getHeight();
        for (Point point : polygon.getPoints()) {
            int oldX = point.getX();
            int oldY = point.getY();
            point.setX(oldHeight - oldY);
            point.setY(oldX);
        }
        polygon.setHeight(oldWidth);
        polygon.setWidth(oldHeight);
        this.relocateText((GraphicsAlgorithm)polygon);
        EList graphicsAlgorithmChildren = polygon.getGraphicsAlgorithmChildren();
        int i = 0;
        while (i < graphicsAlgorithmChildren.size()) {
            if (graphicsAlgorithmChildren.get(i) instanceof Polygon) {
                this.doRotate((Polygon)graphicsAlgorithmChildren.get(i));
            }
            if (i == graphicsAlgorithmChildren.size() - 1) {
                this.createBoxAnchorSet((Shape)this.getContainerShape((GraphicsAlgorithm)polygon));
            }
            ++i;
        }
    }

    @Override
    public void flipHorizontally(GraphicsAlgorithm graphicsAlgorithm) {
        Polygon polygon = (Polygon)graphicsAlgorithm;
        int width = polygon.getWidth();
        for (Point point : polygon.getPoints()) {
            point.setX(width - point.getX());
        }
        EList graphicsAlgorithmChildren = graphicsAlgorithm.getGraphicsAlgorithmChildren();
        int i = 0;
        while (i < graphicsAlgorithmChildren.size()) {
            if (graphicsAlgorithmChildren.get(i) instanceof Polygon) {
                this.flipHorizontally((GraphicsAlgorithm)graphicsAlgorithmChildren.get(i));
            }
            if (i == graphicsAlgorithmChildren.size() - 1) {
                this.createBoxAnchorSet((Shape)this.getContainerShape(graphicsAlgorithm));
            }
            ++i;
        }
    }

    @Override
    public void flipVertically(GraphicsAlgorithm graphicsAlgorithm) {
        Polygon polygon = (Polygon)graphicsAlgorithm;
        int height = polygon.getHeight();
        for (Point point : polygon.getPoints()) {
            point.setY(height - point.getY());
        }
        this.relocateText((GraphicsAlgorithm)polygon);
        EList graphicsAlgorithmChildren = graphicsAlgorithm.getGraphicsAlgorithmChildren();
        int i = 0;
        while (i < graphicsAlgorithmChildren.size()) {
            if (graphicsAlgorithmChildren.get(i) instanceof Polygon) {
                this.flipVertically((GraphicsAlgorithm)graphicsAlgorithmChildren.get(i));
            }
            if (i == graphicsAlgorithmChildren.size() - 1) {
                this.createBoxAnchorSet((Shape)this.getContainerShape(graphicsAlgorithm));
            }
            ++i;
        }
    }

    @Override
    public void resize(GraphicsAlgorithm algorithm, int x, int y, int width, int height) {
        this.ga.setLocationAndSize(algorithm, x, y, width, height);
        ContainerShape container = this.getContainerShape(algorithm);
        this.resizeBoxAnchorSet(container, x, y, width, height);
    }

    @Override
    public void synchronizeMultiInstanceChildren(ContainerShape firstLevelContainer) {
        if (this.isMultipleInstances(firstLevelContainer)) {
            GraphicsAlgorithm foregroundGa = this.getMultiInstanceChild(firstLevelContainer, true);
            GraphicsAlgorithm backgroundGa = this.getMultiInstanceChild(firstLevelContainer, false);
            if (foregroundGa != null && backgroundGa != null && foregroundGa instanceof Polygon) {
                Polygon foregroundPolygon = (Polygon)foregroundGa;
                Polygon backgroundPolygon = (Polygon)backgroundGa;
                int i = 0;
                for (Point mainPoint : foregroundPolygon.getPoints()) {
                    Point backgroundPoint = (Point)backgroundPolygon.getPoints().get(i++);
                    backgroundPoint.setX(mainPoint.getX());
                    backgroundPoint.setY(mainPoint.getY());
                    backgroundPoint.setAfter(mainPoint.getAfter());
                    backgroundPoint.setBefore(mainPoint.getBefore());
                }
            }
        }
    }
}

