/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.conversion.preconditions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifToBddVarOnlySpecificTypesCheck
extends CifCheckNoCompDefInst {
    protected void preprocessDiscVariable(DiscVariable discVar, CifCheckViolations violations) {
        EObject parent = discVar.eContainer();
        if (!(parent instanceof ComplexComponent)) {
            return;
        }
        this.checkType(discVar.getType(), "Discrete", violations);
    }

    protected void preprocessInputVariable(InputVariable inputVar, CifCheckViolations violations) {
        this.checkType(inputVar.getType(), "Input", violations);
    }

    private void checkType(CifType type, String kindTxt, CifCheckViolations violations) {
        CifType normType = CifTypeUtils.normalizeType((CifType)type);
        if (!(normType instanceof BoolType)) {
            if (normType instanceof IntType) {
                IntType intType = (IntType)normType;
                if (CifTypeUtils.isRangeless((IntType)intType)) {
                    violations.add((PositionObject)type, "%s variable has a rangeless integer type", new Object[]{kindTxt});
                } else {
                    if (intType.getLower() < 0) {
                        violations.add((PositionObject)type, "%s variable has an integer type that allows negative numbers", new Object[]{kindTxt});
                    }
                    if (intType.getUpper() == Integer.MAX_VALUE) {
                        violations.add((PositionObject)type, "%s variable has an integer type that allows value 2,147,483,647", new Object[]{kindTxt});
                    }
                }
            } else if (!(normType instanceof EnumType)) {
                violations.add((PositionObject)type, "%s variable does not have a boolean, integer or enumeration type", new Object[]{kindTxt});
            }
        }
    }
}

