/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifSortUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SolverCodeGenerator {
    private SolverCodeGenerator() {
    }

    public static void gencodeSolver(Specification spec, CifCompilerContext ctxt) {
        ContVariable var;
        boolean useDummyVar;
        JavaCodeFile file = ctxt.addCodeFile("Solver");
        CodeBox h = file.header;
        h.add("/** Runtime ODE solver. */");
        h.add("public final class Solver extends OdeSolver<State> {");
        CodeBox c = file.body;
        List vars = (List)CifCollectUtils.collectContVariables((ComplexComponent)spec, (Collection)Lists.list());
        CifSortUtils.sortCifObjects((List)vars);
        int count = vars.size();
        boolean bl = useDummyVar = count == 0;
        if (useDummyVar) {
            count = 1;
        }
        c.add("private static Solver SOLVER;");
        c.add();
        c.add("public static String[] CONT_VAR_NAMES = {");
        c.indent();
        for (ContVariable var2 : vars) {
            c.add("\"%s\",", new Object[]{CifTextUtils.getAbsName((PositionObject)var2)});
        }
        if (useDummyVar) {
            c.add("\"<dummy>\",");
        }
        c.dedent();
        c.add("};");
        c.add();
        c.add("public Solver() {");
        c.indent();
        c.add("super(%s);", new Object[]{Strings.str((Object)useDummyVar)});
        c.dedent();
        c.add("}");
        c.add();
        c.add("public static Solver getSolver() {");
        c.indent();
        c.add("if (SOLVER == null) SOLVER = new Solver();");
        c.add("return SOLVER;");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("protected double[] initY(State state) {");
        c.indent();
        c.add("double[] y = new double[%d];", new Object[]{count});
        if (useDummyVar) {
            c.add("y[0] = 0.0; // dummy variable");
        } else {
            int i = 0;
            while (i < count) {
                var = (ContVariable)vars.get(i);
                c.add("y[%d] = state.%s.%s;", new Object[]{i, ctxt.getContVarSubStateName(var), ctxt.getContVarFieldName(var)});
                ++i;
            }
        }
        c.add("return y;");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public void checkValues(double time, double[] values) {");
        c.indent();
        c.add("if (!isValidValue(time)) throwValueError(time, \"time\");");
        if (!useDummyVar) {
            int i = 0;
            while (i < count) {
                var = (ContVariable)vars.get(i);
                c.add("if (!isValidValue(values[%d])) throwValueError(values[%d], \"%s\");", new Object[]{i, i, CifTextUtils.getAbsName((PositionObject)var)});
                ++i;
            }
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public int getDimension() {");
        c.indent();
        c.add("return %d;", new Object[]{count});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("protected String getContVarName(int idx) {");
        c.indent();
        c.add("return CONT_VAR_NAMES[idx];");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public State makeState(State state, double t, double[] y, boolean copy) {");
        c.indent();
        c.add("State rslt = copy ? State.copy(state) : state;");
        c.add("if (copy) rslt.%s = rslt.%s.copy();", new Object[]{"s", "s"});
        c.add("rslt.%s.time = t;", new Object[]{"s"});
        if (!useDummyVar) {
            Set automata = Sets.set();
            int i = 0;
            while (i < count) {
                ContVariable var3 = (ContVariable)vars.get(i);
                EObject parent = var3.eContainer();
                if (parent instanceof Automaton && !automata.contains(parent)) {
                    Automaton aut = (Automaton)parent;
                    automata.add(aut);
                    c.add("if (copy) rslt.%s = rslt.%s.copy();", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getAutSubStateFieldName(aut)});
                }
                c.add("rslt.%s.%s = (y[%d] == -0.0) ? 0.0 : y[%d];", new Object[]{ctxt.getContVarSubStateName(var3), ctxt.getContVarFieldName(var3), i, i});
                ++i;
            }
        }
        c.add("return rslt;");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("protected void computeDerivatives(State state, double[] yDot) {");
        c.indent();
        if (useDummyVar) {
            c.add("yDot[0] = 1.0; // dummy variable");
        } else {
            int i = 0;
            while (i < count) {
                ContVariable var4 = (ContVariable)vars.get(i);
                c.add("yDot[%d] = %s(state);", new Object[]{i, ctxt.getDerivativeMethodName(var4)});
                ++i;
            }
        }
        c.dedent();
        c.add("}");
    }
}

