/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmlinput1.impl;

import org.xml.sax.Locator;

public class ARPLocation
implements Locator {
    public final String inputName;
    final String publicId;
    public final int endLine;
    public final int endColumn;

    public ARPLocation(Locator locator) {
        if (locator == null) {
            this.inputName = "unknown-source";
            this.publicId = "unknown-source";
            this.endLine = -1;
            this.endColumn = -1;
        } else {
            this.inputName = locator.getSystemId();
            this.endLine = locator.getLineNumber();
            this.endColumn = locator.getColumnNumber();
            this.publicId = locator.getPublicId();
        }
    }

    public String toString() {
        return "line " + this.endLine + " in '" + this.inputName + "'";
    }

    public String locationStr() {
        int line = this.getLineNumber();
        int col = this.getColumnNumber();
        if (col == -1 && line == -1) {
            return "[?, ?]";
        }
        if (col == -1 && line != -1) {
            return String.format("[line: %d]", line);
        }
        if (col != -1 && line == -1) {
            return String.format("[col: %d]", col);
        }
        return String.format("[line: %d, col: %d]", line, col);
    }

    @Override
    public String getSystemId() {
        return this.inputName;
    }

    @Override
    public int getLineNumber() {
        return this.endLine;
    }

    @Override
    public int getColumnNumber() {
        return this.endColumn;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }
}

