/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.factories;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontapi.OntModelControls;
import org.apache.jena.ontapi.common.EnhNodeFactory;
import org.apache.jena.ontapi.common.EnhNodeFilter;
import org.apache.jena.ontapi.common.EnhNodeFinder;
import org.apache.jena.ontapi.common.EnhNodeProducer;
import org.apache.jena.ontapi.common.OntConfig;
import org.apache.jena.ontapi.common.OntEnhGraph;
import org.apache.jena.ontapi.common.OntEnhNodeFactories;
import org.apache.jena.ontapi.common.OntPersonality;
import org.apache.jena.ontapi.impl.factories.OntClasses;
import org.apache.jena.ontapi.impl.objects.OntAnnotationPropertyImpl;
import org.apache.jena.ontapi.impl.objects.OntDataPropertyImpl;
import org.apache.jena.ontapi.impl.objects.OntIndividualImpl;
import org.apache.jena.ontapi.impl.objects.OntNamedDataRangeImpl;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.ontapi.impl.objects.OntObjectPropertyImpl;
import org.apache.jena.ontapi.impl.objects.OntSimpleClassImpl;
import org.apache.jena.ontapi.model.OntAnnotationProperty;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntDataRange;
import org.apache.jena.ontapi.model.OntEntity;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.utils.Graphs;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

final class OntEntities {
    OntEntities() {
    }

    public static EnhNodeFactory createNamedObjectPropertyFactory(OntConfig config) {
        LinkedHashSet<Resource> objectPropertyTypes = new LinkedHashSet<Resource>();
        objectPropertyTypes.add(OWL2.ObjectProperty);
        if (config.getBoolean(OntModelControls.USE_OWL_PROPERTY_INVERSE_FUNCTIONAL_FEATURE)) {
            objectPropertyTypes.add(OWL2.InverseFunctionalProperty);
        }
        if (config.getBoolean(OntModelControls.USE_OWL_PROPERTY_REFLEXIVE_FEATURE)) {
            objectPropertyTypes.add(OWL2.ReflexiveProperty);
        }
        if (config.getBoolean(OntModelControls.USE_OWL_PROPERTY_IRREFLEXIVE_FEATURE)) {
            objectPropertyTypes.add(OWL2.IrreflexiveProperty);
        }
        if (config.getBoolean(OntModelControls.USE_OWL_PROPERTY_SYMMETRIC_FEATURE)) {
            objectPropertyTypes.add(OWL2.SymmetricProperty);
        }
        if (config.getBoolean(OntModelControls.USE_OWL_PROPERTY_ASYMMETRIC_FEATURE)) {
            objectPropertyTypes.add(OWL2.AsymmetricProperty);
        }
        if (config.getBoolean(OntModelControls.USE_OWL_PROPERTY_TRANSITIVE_FEATURE)) {
            objectPropertyTypes.add(OWL2.TransitiveProperty);
        }
        return OntEntities.createOntEntityFactory(OntObjectProperty.Named.class, OntObjectPropertyImpl.NamedImpl.class, OntObjectPropertyImpl.NamedImpl::new, OntPersonality.Builtins::getObjectProperties, OntPersonality.Punnings::getObjectProperties, OWL2.ObjectProperty, objectPropertyTypes.toArray(new Resource[0]));
    }

    public static EnhNodeFactory createDataPropertyFactory() {
        return OntEntities.createOntEntityFactory(OntDataProperty.class, OntDataPropertyImpl.class, OntDataPropertyImpl::new, OntPersonality.Builtins::getDatatypeProperties, OntPersonality.Punnings::getDatatypeProperties, OWL2.DatatypeProperty, new Resource[0]);
    }

    public static EnhNodeFactory createAnnotationPropertyFactory() {
        return OntEntities.createOntEntityFactory(OntAnnotationProperty.class, OntAnnotationPropertyImpl.class, OntAnnotationPropertyImpl::new, OntPersonality.Builtins::getAnnotationProperties, OntPersonality.Punnings::getAnnotationProperties, OWL2.AnnotationProperty, new Resource[0]);
    }

    public static EnhNodeFactory createOWL2NamedClassFactory() {
        return OntEntities.createOntEntityFactory(OntClass.Named.class, OntSimpleClassImpl.NamedImpl.class, OntSimpleClassImpl.NamedImpl::new, OntPersonality.Builtins::getNamedClasses, OntPersonality.Punnings::getNamedClasses, OWL2.Class, new Resource[0]);
    }

    public static EnhNodeFactory createOWL2RLNamedClassFactory() {
        return OntEntities.createOntEntityFactory(OntClass.Named.class, OntSimpleClassImpl.RLNamedImpl.class, OntSimpleClassImpl.RLNamedImpl::new, OntPersonality.Builtins::getNamedClasses, OntPersonality.Punnings::getNamedClasses, OWL2.Class, new Resource[0]);
    }

    public static Function<OntConfig, EnhNodeFactory> createOWL1NamedClassFactory() {
        Set compatibleTypes = Stream.of(OWL2.Class, RDFS.Class, RDFS.Datatype).map(FrontsNode::asNode).collect(Collectors.toUnmodifiableSet());
        return config -> {
            Function<OntPersonality.Punnings, Set<Node>> punnings = OntPersonality.Punnings::getNamedClasses;
            Function<OntPersonality.Builtins, Set> builtins = OntPersonality.Builtins::getNamedClasses;
            boolean useLegacyClassTesting = config.getBoolean(OntModelControls.USE_LEGACY_COMPATIBLE_NAMED_CLASS_FACTORY);
            EnhNodeFinder.ByType finder = new EnhNodeFinder.ByType(OWL2.Class);
            EnhNodeFilter filter = (n, g) -> OntClasses.canBeNamedClass(n, g, useLegacyClassTesting);
            EnhNodeProducer maker = new EnhNodeProducer.WithType(OntSimpleClassImpl.NamedImpl.class, OWL2.Class, OntSimpleClassImpl.NamedImpl::new).restrict(OntEntities.createIllegalPunningsFilter(punnings));
            return OntEnhNodeFactories.createCommon(OntClass.Named.class, maker, (EnhNodeFinder)finder, filter);
        };
    }

    public static EnhNodeFactory createOWL2NamedDataRangeFactory() {
        return OntEntities.createOntEntityFactory(OntDataRange.Named.class, OntNamedDataRangeImpl.class, OntNamedDataRangeImpl::new, OntPersonality.Builtins::getDatatypes, OntPersonality.Punnings::getDatatypes, RDFS.Datatype, new Resource[0]);
    }

    public static EnhNodeFactory createOWL1NamedDataRangeFactory() {
        return OntEnhNodeFactories.createCommon(OntDataRange.class, new EnhNodeProducer.Default(OntNamedDataRangeImpl.class, OntNamedDataRangeImpl::new), EnhNodeFinder.NOTHING, EnhNodeFilter.URI.and(OntEntities.createBuiltinsFilter(OntPersonality.Builtins::getDatatypes)));
    }

    public static EnhNodeFactory createNamedIndividualFactory() {
        EnhNodeFinder.ByType finder = new EnhNodeFinder.ByType(OWL2.NamedIndividual);
        EnhNodeFilter filter = (n, g) -> n.isURI() && OntEntities.testNamedIndividualType(n, g);
        EnhNodeProducer maker = new EnhNodeProducer.WithType(OntIndividualImpl.NamedImpl.class, OWL2.NamedIndividual, OntIndividualImpl.NamedImpl::new).restrict(OntEntities.createIllegalPunningsFilter(OntPersonality.Punnings::getNamedClasses));
        return OntEnhNodeFactories.createCommon(OntIndividual.Named.class, maker, (EnhNodeFinder)finder, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean testNamedIndividualType(Node n, EnhGraph g) {
        OntPersonality personality = OntEnhGraph.asPersonalityModel(g).getOntPersonality();
        if (personality.getBuiltins().getNamedIndividuals().contains(n)) {
            return true;
        }
        Set<Node> forbidden = personality.getPunnings().getNamedIndividuals();
        ArrayList<Node> candidates = new ArrayList<Node>();
        boolean hasDeclaration = false;
        try (ExtendedIterator<Triple> it = g.asGraph().find(n, RDF.Nodes.type, Node.ANY);){
            while (it.hasNext()) {
                Node type = ((Triple)it.next()).getObject();
                if (forbidden.contains(type)) {
                    boolean bl = false;
                    return bl;
                }
                if (OWL2.NamedIndividual.asNode().equals(type)) {
                    hasDeclaration = true;
                    continue;
                }
                candidates.add(type);
            }
        }
        if (hasDeclaration) {
            return true;
        }
        for (Node c : candidates) {
            if (!OntEnhGraph.canAs(OntClass.class, c, g)) continue;
            return true;
        }
        return false;
    }

    public static EnhNodeFactory createOntEntityFactory(Class<? extends OntEntity> classType, Class<? extends OntObjectImpl> impl, BiFunction<Node, EnhGraph, EnhNode> producer, Function<OntPersonality.Builtins, Set<Node>> builtins, Function<OntPersonality.Punnings, Set<Node>> punnings, Resource resourceType, Resource ... alternativeResourceTypes) {
        Set<Resource> resourceTypes = Stream.concat(Stream.of(resourceType), Stream.of(alternativeResourceTypes)).collect(Collectors.toUnmodifiableSet());
        EnhNodeFinder.ByTypes finder = new EnhNodeFinder.ByTypes(resourceTypes);
        EnhNodeFilter filter = OntEntities.createPrimaryEntityFilter(resourceTypes, builtins, punnings);
        EnhNodeProducer maker = new EnhNodeProducer.WithType(impl, resourceType, producer).restrict(OntEntities.createIllegalPunningsFilter(punnings));
        return OntEnhNodeFactories.createCommon(classType, maker, (EnhNodeFinder)finder, filter);
    }

    static EnhNodeFilter createPrimaryEntityFilter(Set<Resource> types, Function<OntPersonality.Builtins, Set<Node>> builtins, Function<OntPersonality.Punnings, Set<Node>> punnings) {
        Set whiteList = types.stream().map(FrontsNode::asNode).collect(Collectors.toUnmodifiableSet());
        return (n, eg) -> {
            if (!n.isURI()) {
                return false;
            }
            OntPersonality personality = OntEnhGraph.asPersonalityModel(eg).getOntPersonality();
            if (((Set)builtins.apply(personality.getBuiltins())).contains(n)) {
                return true;
            }
            Set blackList = (Set)punnings.apply(personality.getPunnings());
            return Graphs.testTypes(n, eg.asGraph(), whiteList, blackList);
        };
    }

    static EnhNodeFilter createIllegalPunningsFilter(Function<OntPersonality.Punnings, Set<Node>> punnings) {
        return (n, eg) -> !OntEntities.hasIllegalPunnings(n, eg, punnings);
    }

    static EnhNodeFilter createBuiltinsFilter(Function<OntPersonality.Builtins, Set<Node>> extractNodeSet) {
        return (n, g) -> OntEntities.isBuiltIn(n, g, extractNodeSet);
    }

    static boolean hasIllegalPunnings(Node n, EnhGraph eg, Function<OntPersonality.Punnings, Set<Node>> extractNodeSet) {
        Set<Node> punnings = extractNodeSet.apply(OntEnhGraph.asPersonalityModel(eg).getOntPersonality().getPunnings());
        return Graphs.hasOneOfType(n, eg.asGraph(), punnings);
    }

    static boolean isBuiltIn(Node n, EnhGraph eg, Function<OntPersonality.Builtins, Set<Node>> extractNodeSet) {
        return extractNodeSet.apply(OntEnhGraph.asPersonalityModel(eg).getOntPersonality().getBuiltins()).contains(n);
    }
}

