/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Objects;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.rowset.RowSetWriter;
import org.apache.jena.riot.rowset.RowSetWriterFactory;
import org.apache.jena.riot.thrift.ThriftRDF;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;

public class RowSetWriterThrift
implements RowSetWriter {
    public static RowSetWriterFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_Thrift)) {
            throw new ResultSetException("RowSetWriter for RDF/Thrift asked for a " + lang);
        }
        return new RowSetWriterThrift();
    };

    @Override
    public void write(OutputStream out, RowSet rowSet, Context context2) {
        ThriftRDF.writeRowSet(out, rowSet);
    }

    @Override
    public void write(Writer out, RowSet resultSet, Context context2) {
        throw new NotImplemented("Writing binary data to a java.io.Writer is not possible");
    }

    @Override
    public void write(OutputStream out, boolean result, Context context2) {
        throw new NotImplemented("No Thrift RDF encoding defined for boolean results");
    }
}

