/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.views;

import java.util.ArrayList;
import org.eclipse.emf.emfstore.client.model.ServerInfo;
import org.eclipse.emf.emfstore.client.model.connectionmanager.KeyStoreManager;
import org.eclipse.emf.emfstore.client.model.exceptions.CertificateStoreException;
import org.eclipse.emf.emfstore.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.views.CertificateSelectionDialog;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.views.NewRepositoryWizard;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class NewRepositoryWizardPageOne
extends WizardPage {
    private static final int DEFAULT_PORT = 8080;
    private Text name;
    private Text url;
    private Spinner port;
    private Combo cert;

    public NewRepositoryWizardPageOne() {
        super("Main");
        this.setTitle("Server Details");
        this.setDescription("Select the details for the new repository");
    }

    public void createControl(Composite parent) {
        block7: {
            int ncol;
            NewRepositoryWizard wizard = (NewRepositoryWizard)this.getWizard();
            ServerInfo serverInfo = wizard.getServerInfo();
            Composite composite = new Composite(parent, 0);
            GridLayout gl = new GridLayout();
            gl.numColumns = ncol = 3;
            composite.setLayout((Layout)gl);
            new Label(composite, 0).setText("Name:");
            this.name = new Text(composite, 2048);
            GridData gd = new GridData(768);
            gd.horizontalSpan = ncol - 1;
            this.name.setLayoutData((Object)gd);
            new Label(composite, 0).setText("URL:");
            this.url = new Text(composite, 2048);
            gd = new GridData(768);
            gd.horizontalSpan = ncol - 1;
            this.url.setLayoutData((Object)gd);
            new Label(composite, 0).setText("Port:");
            this.port = new Spinner(composite, 2048);
            gd = new GridData(768);
            gd.horizontalSpan = ncol - 1;
            this.port.setLayoutData((Object)gd);
            this.port.setValues(8080, 1, 999999, 0, 1, 10);
            this.setControl((Control)composite);
            new Label(composite, 0).setText("Certificate:");
            this.cert = new Combo(composite, 2048);
            gd = new GridData(768);
            gd.horizontalSpan = ncol - 2;
            this.cert.setLayoutData((Object)gd);
            this.cert.setBackground(Display.getCurrent().getSystemColor(1));
            this.initCombo();
            Button button = new Button(composite, 0);
            button.setText("Edit");
            button.addSelectionListener((SelectionListener)new SelectionDialogListener());
            gd = new GridData(128);
            gd.horizontalSpan = 1;
            button.setLayoutData((Object)gd);
            if (serverInfo.getUrl() != null) {
                this.name.setText(serverInfo.getName());
                this.url.setText(serverInfo.getUrl());
                this.port.setSelection(serverInfo.getPort());
                if (serverInfo.getCertificateAlias() == null) {
                    return;
                }
                try {
                    if (KeyStoreManager.getInstance().contains(serverInfo.getCertificateAlias())) {
                        int i = 0;
                        while (i < this.cert.getItemCount()) {
                            if (this.cert.getItem(i).equals(serverInfo.getCertificateAlias())) {
                                this.cert.select(i);
                                break block7;
                            }
                            ++i;
                        }
                        break block7;
                    }
                    this.cert.setText("");
                }
                catch (CertificateStoreException e1) {
                    this.cert.setText("");
                }
            }
        }
    }

    private void initCombo() {
        try {
            ArrayList certificates = KeyStoreManager.getInstance().getCertificates();
            String[] aliases = new String[certificates.size()];
            int i = 0;
            while (i < certificates.size()) {
                aliases[i] = (String)certificates.get(i);
                ++i;
            }
            this.cert.setItems(aliases);
        }
        catch (CertificateStoreException e) {
            WorkspaceUtil.logException((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public boolean canFlipToNextPage() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        if (NewRepositoryWizardPageOne.isTextNonEmpty(this.name.getText()) && NewRepositoryWizardPageOne.isTextNonEmpty(this.url.getText()) && this.isComboNotEmpty()) {
            this.saveDataToModel();
            return true;
        }
        return false;
    }

    private void saveDataToModel() {
        new EMFStoreCommand(){

            protected void doRun() {
                NewRepositoryWizard wizard = (NewRepositoryWizard)NewRepositoryWizardPageOne.this.getWizard();
                ServerInfo serverInfo = wizard.getServerInfo();
                serverInfo.setName(NewRepositoryWizardPageOne.this.name.getText());
                serverInfo.setUrl(NewRepositoryWizardPageOne.this.url.getText());
                serverInfo.setPort(NewRepositoryWizardPageOne.this.port.getSelection());
                serverInfo.setCertificateAlias(NewRepositoryWizardPageOne.this.cert.getText());
            }
        }.run();
    }

    private static boolean isTextNonEmpty(String s) {
        return s != null && s.trim().length() > 0;
    }

    private boolean isComboNotEmpty() {
        String s = this.cert.getItem(this.cert.getSelectionIndex());
        return NewRepositoryWizardPageOne.isTextNonEmpty(s);
    }

    class SelectionDialogListener
    implements SelectionListener {
        SelectionDialogListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CertificateSelectionDialog csd = new CertificateSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof String) {
                        return element.toString();
                    }
                    return "";
                }
            });
            try {
                ArrayList certificates = KeyStoreManager.getInstance().getCertificates();
                csd.setElements(certificates.toArray());
            }
            catch (CertificateStoreException e1) {
                csd.setErrorMessage(e1.getMessage());
            }
            csd.setBlockOnOpen(true);
            csd.setTitle("Certificate Selection Dialog");
            csd.open();
            if (csd.getReturnCode() == 0) {
                NewRepositoryWizardPageOne.this.initCombo();
                int i = 0;
                while (i < NewRepositoryWizardPageOne.this.cert.getItemCount()) {
                    String item = NewRepositoryWizardPageOne.this.cert.getItem(i);
                    if (item.equals(csd.getCertificateAlias())) {
                        NewRepositoryWizardPageOne.this.cert.select(i);
                        break;
                    }
                    ++i;
                }
            }
        }
    }
}

