/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.model.ECPModelelementContext;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;

public class MEEditorInput
implements IEditorInput {
    private EObject modelElement;
    private EStructuralFeature problemFeature;
    private DecoratingLabelProvider labelProvider;
    private ECPModelelementContext modelElementContext;
    private ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public MEEditorInput(EObject me, ECPModelelementContext context, EStructuralFeature problemFeature) {
        this(me, context);
        this.problemFeature = problemFeature;
    }

    public MEEditorInput(EObject me, ECPModelelementContext context) {
        AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        this.labelProvider = new DecoratingLabelProvider((ILabelProvider)adapterFactoryLabelProvider, decoratorManager.getLabelDecorator());
        this.modelElement = me;
        this.modelElementContext = context;
        if (this.labelProvider.getLabelProvider().getText((Object)this.modelElement) == null) {
            Shell activeShell = Display.getCurrent().getActiveShell();
            boolean doSetName = MessageDialog.openQuestion((Shell)activeShell, (String)"Missing title", (String)"The element you are trying to open does not have a proper name and cannot be opened.\nDo you want to set a custom name for it or use a default one?");
            String newName = "new " + this.modelElement.eClass().getName();
            if (doSetName) {
                InputDialog inputDialog = new InputDialog(activeShell, "New title", "Please enter the new name for this element", newName, null);
                inputDialog.setBlockOnOpen(true);
                if (inputDialog.open() == 0 && inputDialog.getValue() != "") {
                    newName = inputDialog.getValue();
                }
            }
        }
    }

    public DecoratingLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)this.labelProvider.getImage((Object)this.modelElement));
        return descriptor;
    }

    public String getName() {
        return this.labelProvider.getLabelProvider().getText((Object)this.modelElement);
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public EObject getModelElement() {
        return this.modelElement;
    }

    public void setModelElement(EObject modelElement) {
        this.modelElement = modelElement;
    }

    public EStructuralFeature getProblemFeature() {
        return this.problemFeature;
    }

    public void setProblemFeature(EStructuralFeature problemFeature) {
        this.problemFeature = problemFeature;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MEEditorInput) {
            MEEditorInput other = (MEEditorInput)obj;
            boolean ret = this.modelElement.equals(other.modelElement);
            return ret;
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(EObject.class)) {
            return this.getModelElement();
        }
        return null;
    }

    public ECPModelelementContext getModelElementContext() {
        return this.modelElementContext;
    }

    public void dispose() {
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
        }
    }
}

