/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.image;

import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import org.eclipse.fx.core.bindings.FXBindings;
import org.eclipse.fx.core.bindings.FXCollectors;
import org.eclipse.fx.ui.controls.image.MultiDimensionImage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ScalingImageViewer
extends Region {
    private final ObjectProperty<@NonNull Dimension> derivedDimension = new SimpleObjectProperty<Dimension>((Object)this, "derivedDimension", Dimension.BOTH){

        protected void invalidated() {
            super.invalidated();
            ScalingImageViewer.this.requestLayout();
        }
    };
    private ObjectProperty<@Nullable MultiDimensionImage> image = new SimpleObjectProperty<MultiDimensionImage>((Object)this, "image"){

        protected void invalidated() {
            super.invalidated();
            ScalingImageViewer.this.requestLayout();
        }
    };
    private final ObjectProperty<@NonNull Pos> anker = new SimpleObjectProperty<Pos>((Object)this, "anker", Pos.TOP_LEFT){

        protected void invalidated() {
            super.invalidated();
            ScalingImageViewer.this.requestLayout();
        }
    };
    private final ImageView imageView = new ImageView();

    public ScalingImageViewer() {
        this.imageView.setManaged(false);
        ObjectBinding dimImg = (ObjectBinding)FXBindings.bindStream(this.image).map(m -> m == null ? null : m.imageProperty()).collect(FXCollectors.toBinding());
        ObjectBinding ratioBinding = (ObjectBinding)FXBindings.bindStream(this.image).map(m -> m == null ? null : m.ratioProperty()).collect(FXCollectors.toBinding());
        ratioBinding.addListener((ob, ol, ne) -> {
            this.requestLayout();
            this.layout();
        });
        this.imageView.imageProperty().bind((ObservableValue)dimImg);
        this.getChildren().add((Object)this.imageView);
    }

    public Orientation getContentBias() {
        switch (this.getDerivedDimension()) {
            case HEIGHT: {
                return Orientation.HORIZONTAL;
            }
            case WIDTH: {
                return Orientation.VERTICAL;
            }
        }
        return null;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        MultiDimensionImage img = this.getImage();
        if (img != null) {
            double h;
            double w;
            switch (this.getDerivedDimension()) {
                case HEIGHT: {
                    w = this.getWidth() - this.snappedLeftInset() - this.snappedRightInset();
                    h = w / img.getRatio() - this.snappedTopInset() - this.snappedBottomInset();
                    break;
                }
                case WIDTH: {
                    h = this.getHeight() - this.snappedTopInset() - this.snappedBottomInset();
                    w = h * img.getRatio() - this.snappedLeftInset() - this.snappedRightInset();
                }
                default: {
                    w = this.getWidth() - this.snappedLeftInset() - this.snappedRightInset();
                    h = w / img.getRatio() - this.snappedTopInset() - this.snappedBottomInset();
                    if (!(h > this.getHeight() - this.snappedTopInset() - this.snappedBottomInset())) break;
                    h = this.getHeight() - this.snappedTopInset() - this.snappedBottomInset();
                    w = h * img.getRatio() - this.snappedLeftInset() - this.snappedRightInset();
                }
            }
            img.updateDimension(w, h);
            this.imageView.setFitWidth(w);
            this.imageView.setFitHeight(h);
            double x = switch (((Pos)this.anker.get()).getHpos()) {
                case HPos.LEFT -> this.snappedLeftInset();
                case HPos.CENTER -> this.getWidth() / 2.0 - w / 2.0;
                default -> this.getWidth() - this.snappedRightInset() - w;
            };
            double y = switch (((Pos)this.anker.getValue()).getVpos()) {
                case VPos.BASELINE, VPos.BOTTOM -> this.getHeight() - this.snappedBottomInset() - h;
                case VPos.CENTER -> this.getHeight() / 2.0 - h / 2.0;
                default -> this.snappedTopInset();
            };
            x = this.snapPosition(x);
            y = this.snapPosition(y);
            this.imageView.resizeRelocate(x, y, w, h);
        }
    }

    public final ObjectProperty<@NonNull Dimension> derivedDimensionProperty() {
        return this.derivedDimension;
    }

    public final @NonNull Dimension getDerivedDimension() {
        return (Dimension)((Object)this.derivedDimensionProperty().get());
    }

    public final void setDerivedDimension(@NonNull Dimension derivedDimension) {
        this.derivedDimensionProperty().set((Object)derivedDimension);
    }

    public final ObjectProperty<@Nullable MultiDimensionImage> imageProperty() {
        return this.image;
    }

    public final @Nullable MultiDimensionImage getImage() {
        return (MultiDimensionImage)this.imageProperty().get();
    }

    public final void setImage(@Nullable MultiDimensionImage image) {
        this.imageProperty().set((Object)image);
    }

    protected double computeMinHeight(double width) {
        MultiDimensionImage img = this.getImage();
        if (img == null) {
            return super.computeMinHeight(width);
        }
        switch (this.getDerivedDimension()) {
            case HEIGHT: {
                double w = width - this.snappedLeftInset() - this.snappedRightInset();
                return w / img.getRatio() - this.snappedTopInset() - this.snappedBottomInset();
            }
        }
        return super.computeMinHeight(width);
    }

    protected double computePrefHeight(double width) {
        return super.computeMinHeight(width);
    }

    protected double computeMinWidth(double height) {
        MultiDimensionImage img = this.getImage();
        if (img == null) {
            return super.computeMinWidth(height);
        }
        switch (this.getDerivedDimension()) {
            case WIDTH: {
                double h = height - this.snappedTopInset() - this.snappedBottomInset();
                return h * img.getRatio() - this.snappedLeftInset() - this.snappedRightInset();
            }
        }
        return super.computeMinWidth(height);
    }

    protected double computePrefWidth(double height) {
        return super.computeMinWidth(height);
    }

    public final ObjectProperty<Pos> ankerProperty() {
        return this.anker;
    }

    public final Pos getAnker() {
        return (Pos)this.ankerProperty().get();
    }

    public final void setAnker(Pos anker) {
        this.ankerProperty().set((Object)anker);
    }

    public static enum Dimension {
        BOTH,
        HEIGHT,
        WIDTH;

    }
}

