/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.ui.preview;

import com.google.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.fx.ide.ui.editor.IFXMLProviderAdapter;
import org.eclipse.fx.ide.ui.editor.IFXPreviewAdapter;
import org.eclipse.fx.ide.ui.preview.LivePreviewPart;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.EditorPart;

public class LivePreviewSynchronizer
implements IPartListener,
IPropertyListener {
    @Inject
    private LivePreviewPart view;
    private IFXPreviewAdapter currentEditor;
    private IFXMLProviderAdapter currentContentProvider;

    public void partActivated(IWorkbenchPart part) {
        this.updateView(part);
    }

    private void updateView(IWorkbenchPart part) {
        IFXPreviewAdapter adapted = part instanceof IFXPreviewAdapter ? (IFXPreviewAdapter)part : (IFXPreviewAdapter)part.getAdapter(IFXPreviewAdapter.class);
        if (adapted != null) {
            if (this.currentEditor == null || !this.currentEditor.getEditorPart().equals(adapted.getEditorPart())) {
                if (this.currentEditor != null) {
                    this.currentEditor.getEditorPart().removePropertyListener((IPropertyListener)this);
                }
                this.currentEditor = adapted;
                if (this.currentEditor != null) {
                    this.currentEditor.getEditorPart().addPropertyListener((IPropertyListener)this);
                }
                if (this.currentEditor instanceof IFXMLProviderAdapter && (this.currentContentProvider == null || !this.currentContentProvider.getEditorPart().equals(this.currentEditor.getEditorPart()))) {
                    this.currentContentProvider = (IFXMLProviderAdapter)this.currentEditor;
                    this.view.setContents(this.createContentData(this.currentContentProvider));
                }
            }
        } else if (part instanceof EditorPart) {
            if (this.currentEditor != null) {
                this.currentEditor.getEditorPart().removePropertyListener((IPropertyListener)this);
            }
            this.currentContentProvider = null;
            this.currentEditor = null;
            this.view.setContents(null);
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 257 && this.currentEditor != null && !this.currentEditor.getEditorPart().isDirty() && this.currentContentProvider != null) {
            this.view.setContents(this.createContentData(this.currentContentProvider));
        }
    }

    public void refreshPreview() {
        if (this.currentContentProvider != null) {
            this.view.setContents(this.createContentData(this.currentContentProvider));
        }
    }

    private LivePreviewPart.ContentData createContentData(IFXMLProviderAdapter contentProvider) {
        String contents = contentProvider.getPreviewFXML();
        String previewSceneSetup = contentProvider.getPreviewSceneFXML();
        List cssFiles = contentProvider.getPreviewCSSFiles();
        String resourceBundle = contentProvider.getPreviewResourceBundle();
        List previewUrls = contentProvider.getPreviewClasspath();
        IFile file = contentProvider.getFile();
        ArrayList<URL> extraJarPath = new ArrayList<URL>();
        extraJarPath.addAll(previewUrls);
        if (file != null) {
            extraJarPath.addAll(this.calculateProjectClasspath(JavaCore.create((IProject)file.getProject())));
        }
        return new LivePreviewPart.ContentData(contents, previewSceneSetup, cssFiles, resourceBundle, extraJarPath, file);
    }

    private void resolveDataProject(IJavaProject project, Set<IPath> outputPath, Set<IPath> listRefLibraries) {
        try {
            IClasspathEntry[] entries = project.getRawClasspath();
            outputPath.add(project.getOutputLocation());
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p;
                int n3;
                int n4;
                IClasspathEntry[] iClasspathEntryArray2;
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (e.getEntryKind() == 2) {
                    IProject p2 = ResourcesPlugin.getWorkspace().getRoot().getProject(e.getPath().lastSegment());
                    if (p2.exists()) {
                        this.resolveDataProject(JavaCore.create((IProject)p2), outputPath, listRefLibraries);
                    }
                } else if (e.getEntryKind() == 1) {
                    listRefLibraries.add(e.getPath());
                } else if ("org.eclipse.pde.core.requiredPlugins".equals(e.getPath().toString())) {
                    IClasspathContainer cpContainer = JavaCore.getClasspathContainer((IPath)e.getPath(), (IJavaProject)project);
                    iClasspathEntryArray2 = cpContainer.getClasspathEntries();
                    n4 = iClasspathEntryArray2.length;
                    n3 = 0;
                    while (n3 < n4) {
                        IClasspathEntry cpEntry = iClasspathEntryArray2[n3];
                        if (cpEntry.getEntryKind() == 2) {
                            p = ResourcesPlugin.getWorkspace().getRoot().getProject(cpEntry.getPath().lastSegment());
                            if (p.exists()) {
                                this.resolveDataProject(JavaCore.create((IProject)p), outputPath, listRefLibraries);
                            }
                        } else if (cpEntry.getEntryKind() == 1) {
                            listRefLibraries.add(cpEntry.getPath());
                        }
                        ++n3;
                    }
                } else if (e.getEntryKind() == 5 && !e.getPath().toString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER") && !e.getPath().toString().startsWith("org.eclipse.fx.ide.jdt.core.JAVAFX_CONTAINER")) {
                    IClasspathContainer cp = JavaCore.getClasspathContainer((IPath)e.getPath(), (IJavaProject)project);
                    iClasspathEntryArray2 = cp.getClasspathEntries();
                    n4 = iClasspathEntryArray2.length;
                    n3 = 0;
                    while (n3 < n4) {
                        IClasspathEntry ce = iClasspathEntryArray2[n3];
                        if (ce.getEntryKind() == 1) {
                            listRefLibraries.add(ce.getPath());
                        } else if (ce.getEntryKind() == 2 && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(ce.getPath().lastSegment())).exists()) {
                            this.resolveDataProject(JavaCore.create((IProject)p), outputPath, listRefLibraries);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private List<URL> calculateProjectClasspath(IJavaProject jp) {
        IFolder f;
        HashSet<IPath> outputPath = new HashSet<IPath>();
        HashSet<IPath> libraries = new HashSet<IPath>();
        this.resolveDataProject(jp, outputPath, libraries);
        IWorkspaceRoot root = jp.getProject().getWorkspace().getRoot();
        ArrayList<URL> rv = new ArrayList<URL>();
        for (IPath out : outputPath) {
            f = root.getFolder(out);
            if (!f.exists()) continue;
            try {
                rv.add(f.getLocation().toFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        for (IPath lib : libraries) {
            f = root.getFile(lib);
            if (f.exists()) {
                try {
                    rv.add(f.getLocation().toFile().toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!lib.toFile().exists()) continue;
            try {
                rv.add(lib.toFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return rv;
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

