/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.conversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.internal.project.conversion.ProjectConversionParticipantSorter;
import org.eclipse.m2e.core.project.conversion.AbstractProjectConversionParticipant;
import org.eclipse.m2e.core.project.conversion.IProjectConversionEnabler;
import org.eclipse.m2e.core.project.conversion.IProjectConversionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectConversionManager
implements IProjectConversionManager {
    private static final String CONVERSION_PARTICIPANTS_EXTENSION_POINT = "org.eclipse.m2e.core.projectConversionParticipants";
    private static final Logger log = LoggerFactory.getLogger(ProjectConversionManager.class);
    private static final int DEFAULT_WEIGHT = 50;
    private static IProjectConversionEnabler[] enablers;
    private static final String CONVERSION_ENABLER_EXTENSION_POINT = "org.eclipse.m2e.core.conversionEnabler";

    private static List<AbstractProjectConversionParticipant> lookupConversionParticipants(IProject project) {
        ArrayList<AbstractProjectConversionParticipant> participants = new ArrayList<AbstractProjectConversionParticipant>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint conversionExtensionPoint = registry.getExtensionPoint(CONVERSION_PARTICIPANTS_EXTENSION_POINT);
        HashMap<String, Set<String>> restrictedPackagings = new HashMap<String, Set<String>>();
        if (conversionExtensionPoint != null) {
            IExtension[] archetypesExtensions;
            IExtension[] iExtensionArray = archetypesExtensions = conversionExtensionPoint.getExtensions();
            int n = archetypesExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if ("projectConversionParticipant".equals(element.getName())) {
                        try {
                            if (project.hasNature(element.getAttribute("nature"))) {
                                AbstractProjectConversionParticipant projectConversionParticipant = (AbstractProjectConversionParticipant)element.createExecutableExtension("class");
                                participants.add(projectConversionParticipant);
                            }
                        }
                        catch (CoreException ex) {
                            log.debug("Can not load IProjectConversionParticipant", (Throwable)ex);
                        }
                    } else if ("conversionParticipantConfiguration".equals(element.getName())) {
                        ProjectConversionManager.setRestrictedPackagings(restrictedPackagings, element);
                    }
                    ++n4;
                }
                ++n2;
            }
            for (AbstractProjectConversionParticipant cp : participants) {
                Set newPackagings = (Set)restrictedPackagings.get(cp.getId());
                if (newPackagings == null) continue;
                for (String p : newPackagings) {
                    cp.addRestrictedPackaging(p);
                }
            }
        }
        return participants;
    }

    private static void setRestrictedPackagings(Map<String, Set<String>> restrictedPackagings, IConfigurationElement element) {
        String pid = element.getAttribute("conversionParticipantId");
        String packagesAsString = element.getAttribute("compatiblePackagings");
        if (pid != null && packagesAsString != null) {
            try {
                String[] packagingsArray = packagesAsString.split(",");
                HashSet<String> packagings = new HashSet<String>(packagingsArray.length);
                String[] stringArray = packagingsArray;
                int n = packagingsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String packaging = stringArray[n2];
                    String p = packaging.trim();
                    if (p.length() > 0) {
                        packagings.add(p);
                    }
                    ++n2;
                }
                Set<String> allPackages = restrictedPackagings.get(pid);
                if (allPackages == null) {
                    allPackages = new HashSet<String>();
                    restrictedPackagings.put(pid, allPackages);
                }
                allPackages.addAll(packagings);
            }
            catch (Exception e) {
                log.debug("Cannot parse restricted packagings ", (Throwable)e);
            }
        }
    }

    @Override
    public void convert(IProject project, Model model, IProgressMonitor monitor) throws CoreException {
        if (model == null) {
            return;
        }
        List<AbstractProjectConversionParticipant> participants = this.getConversionParticipants(project, model.getPackaging());
        if (participants != null) {
            for (AbstractProjectConversionParticipant participant : participants) {
                participant.convert(project, model, monitor);
            }
        }
    }

    @Override
    @Deprecated
    public List<AbstractProjectConversionParticipant> getConversionParticipants(IProject project) throws CoreException {
        return this.getConversionParticipants(project, null);
    }

    @Override
    public List<AbstractProjectConversionParticipant> getConversionParticipants(IProject project, String packaging) throws CoreException {
        List<AbstractProjectConversionParticipant> allParticipants = ProjectConversionManager.lookupConversionParticipants(project);
        ArrayList<AbstractProjectConversionParticipant> participants = new ArrayList<AbstractProjectConversionParticipant>();
        if (allParticipants != null) {
            for (AbstractProjectConversionParticipant participant : allParticipants) {
                if (packaging != null && !participant.isPackagingCompatible(packaging) || !participant.accept(project)) continue;
                participants.add(participant);
            }
        }
        try {
            ProjectConversionParticipantSorter sorter = new ProjectConversionParticipantSorter(participants);
            return Collections.unmodifiableList(sorter.getSortedConverters());
        }
        catch (CycleDetectedException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", ex.getMessage()));
        }
    }

    private static IProjectConversionEnabler[] loadProjectConversionEnablers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(CONVERSION_ENABLER_EXTENSION_POINT);
        List<IConfigurationElement> list = Arrays.asList(cf);
        Comparator<IConfigurationElement> c = Comparator.comparingInt(o -> {
            String weight = o.getAttribute("weight");
            try {
                return Integer.parseInt(weight);
            }
            catch (NumberFormatException nfe1) {
                return 50;
            }
        }).reversed();
        Collections.sort(list, c);
        ArrayList<IProjectConversionEnabler> retList = new ArrayList<IProjectConversionEnabler>();
        Iterator<IConfigurationElement> i = list.iterator();
        while (i.hasNext()) {
            try {
                IConfigurationElement element = i.next();
                retList.add((IProjectConversionEnabler)element.createExecutableExtension("class"));
                if (!log.isDebugEnabled()) continue;
                String id = element.getAttribute("id");
                String sWeight = element.getAttribute("weight");
                log.debug("Project conversion enabler found - id: {}, weight: {}", (Object)id, (Object)sWeight);
            }
            catch (CoreException ce) {
                log.error(ce.getMessage(), (Throwable)ce);
            }
        }
        return retList.toArray(new IProjectConversionEnabler[retList.size()]);
    }

    @Override
    public IProjectConversionEnabler getConversionEnablerForProject(IProject project) {
        if (enablers == null) {
            enablers = ProjectConversionManager.loadProjectConversionEnablers();
        }
        IProjectConversionEnabler result = null;
        IProjectConversionEnabler[] iProjectConversionEnablerArray = enablers;
        int n = enablers.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectConversionEnabler enabler = iProjectConversionEnablerArray[n2];
            if (enabler.accept(project)) {
                result = enabler;
                break;
            }
            ++n2;
        }
        if (log.isDebugEnabled()) {
            if (result != null) {
                log.debug("Project conversion enabler found for project: {} - Class: {} ", (Object)project.getName(), (Object)result.getClass().getName());
            } else {
                log.debug("Project conversion enabler not found for project: {}", (Object)project.getName());
            }
        }
        return result;
    }
}

