/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPerspective;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWindow;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class BasePerspectiveRenderer<N>
extends BaseRenderer<MPerspective, WPerspective<N>> {
    @Inject
    @Log
    Logger logger;

    @PostConstruct
    void init(IEventBroker eventBroker) {
        eventBroker.subscribe("org/eclipse/e4/ui/model/advanced/Perspective/windows/*", new EventHandler(){

            public void handleEvent(Event event) {
                MPerspective perspective;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MPerspective && BasePerspectiveRenderer.this == (perspective = (MPerspective)changedObj).getRenderer()) {
                    String eventType = (String)event.getProperty("EventType");
                    if ("ADD".equals(eventType)) {
                        MUIElement element = (MUIElement)event.getProperty("NewValue");
                        if (element instanceof MWindow) {
                            BasePerspectiveRenderer.this.handleWindowAdd((MWindow)element);
                        } else if (element instanceof MPartSashContainerElement) {
                            BasePerspectiveRenderer.this.handleChildAdd((MPartSashContainerElement)element);
                        } else {
                            BasePerspectiveRenderer.this.getLogger().error("ERROR: Unhandled child addition: " + element);
                        }
                    } else if ("REMOVE".equals(eventType)) {
                        MUIElement element = (MUIElement)event.getProperty("OldValue");
                        if (element instanceof MWindow) {
                            BasePerspectiveRenderer.this.handleWindowRemove((MWindow)element);
                        } else if (element instanceof MPartSashContainerElement) {
                            BasePerspectiveRenderer.this.handleChildRemove((MPartSashContainerElement)element);
                        } else {
                            BasePerspectiveRenderer.this.getLogger().error("ERROR: Unhandled child removal: " + element);
                        }
                    }
                }
            }
        });
    }

    void handleWindowAdd(@NonNull MWindow window) {
        this.engineCreateWidget(window);
    }

    void handleWindowRemove(MWindow window) {
    }

    void handleChildAdd(@NonNull MPartSashContainerElement element) {
        this.engineCreateWidget(element);
    }

    void handleChildRemove(MPartSashContainerElement element) {
    }

    @Override
    protected void doProcessContent(MPerspective element) {
        ArrayList<WLayoutedWidget<MPartSashContainerElement>> list = new ArrayList<WLayoutedWidget<MPartSashContainerElement>>();
        for (MPartSashContainerElement e : element.getChildren()) {
            WLayoutedWidget w;
            if (!e.isToBeRendered() || (w = (WLayoutedWidget)this.engineCreateWidget(e)) == null || !this.isChildRenderedAndVisible((MUIElement)e)) continue;
            list.add(w);
        }
        @Nullable WPerspective widget = (WPerspective)this.getWidget((MUIElement)element);
        if (widget == null) {
            this.getLogger().error("No widget found for '" + element + "'");
        } else {
            widget.addItems(list);
        }
        if (!element.getWindows().isEmpty()) {
            MWindow window = BasePerspectiveRenderer.findParent((EObject)element);
            WWindow topLevel = (WWindow)window.getWidget();
            for (MWindow w : element.getWindows()) {
                if (!w.isToBeRendered()) continue;
                WWindow ww = (WWindow)this.engineCreateWidget(w);
                if (ww != null) {
                    topLevel.addChildWindow(ww);
                    continue;
                }
                this.getLogger().error("No widget was created for element '" + w + "'");
            }
        }
    }

    private static MWindow findParent(EObject e) {
        EObject tmp = e;
        if (tmp.eContainer() instanceof MApplication) {
            return null;
        }
        do {
            if (!((tmp = tmp.eContainer()) instanceof MWindow)) continue;
            return (MWindow)tmp;
        } while (tmp.eContainer() != null);
        return null;
    }

    public void childRendered(MPerspective parentElement, MUIElement element) {
        WWindow ww;
        MWindow parent;
        WWindow w;
        if (this.inContentProcessing((MUIElement)parentElement) || !this.isChildRenderedAndVisible(element)) {
            return;
        }
        if (element instanceof MPartSashContainerElement) {
            WLayoutedWidget widget = (WLayoutedWidget)element.getWidget();
            if (widget != null) {
                WPerspective wPerspective = (WPerspective)this.getWidget((MUIElement)parentElement);
                if (wPerspective != null) {
                    wPerspective.addItem(this.getRenderedIndex((MUIElement)parentElement, element), widget);
                } else {
                    this.getLogger().error("No widget found for '" + parentElement + "'");
                }
            } else {
                this.getLogger().error("Expected widget from '" + element + "'");
            }
        } else if (element instanceof MWindow && (w = (WWindow)(parent = BasePerspectiveRenderer.findParent((EObject)parentElement)).getWidget()) != null && (ww = (WWindow)element.getWidget()) != null) {
            w.addChildWindow(ww);
        }
    }

    public void hideChild(MPerspective container, MUIElement changedObj) {
        WWindow ww;
        MWindow parent;
        WWindow w;
        WPerspective perspective = (WPerspective)this.getWidget((MUIElement)container);
        if (perspective == null) {
            return;
        }
        if (changedObj instanceof MPartSashContainerElement) {
            WLayoutedWidget widget = (WLayoutedWidget)changedObj.getWidget();
            if (widget != null) {
                perspective.removeItem(widget);
            }
        } else if (changedObj instanceof MWindow && (w = (WWindow)(parent = BasePerspectiveRenderer.findParent((EObject)container)).getWidget()) != null && (ww = (WWindow)changedObj.getWidget()) != null) {
            w.removeChildWindow(ww);
        }
    }
}

