/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.util.Optional;
import org.eclipse.fx.core.Version;
import org.eclipse.fx.core.log.LoggerCreator;
import org.osgi.framework.FrameworkUtil;

public class SystemUtils {
    private static Boolean isOSGi;

    public static boolean isFX2() {
        return System.getProperty("javafx.version") != null && System.getProperty("javafx.version").startsWith("2");
    }

    public static boolean isFX9() {
        return System.getProperty("javafx.version") != null && System.getProperty("javafx.version").startsWith("9");
    }

    public static boolean isFX8() {
        return System.getProperty("javafx.version") != null && System.getProperty("javafx.version").startsWith("8");
    }

    public static int getMajorFXVersion() {
        return Integer.parseInt(System.getProperty("javafx.version").split("\\.")[0]);
    }

    public static boolean isOsgiEnv() {
        if (isOSGi == null) {
            isOSGi = Boolean.FALSE;
            try {
                Class.forName("org.osgi.framework.FrameworkUtil");
                if (FrameworkUtil.getBundle(SystemUtils.class) != null) {
                    isOSGi = Boolean.TRUE;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return isOSGi;
    }

    public static boolean isMacOS() {
        return "Mac OS X".equals(System.getProperty("os.name"));
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static Optional<Version> getJavaVersion() {
        String version = System.getProperty("java.runtime.version");
        if (version.startsWith("1.")) {
            String v = version.substring(2).replaceFirst("_", ".");
            try {
                return Optional.of(Version.createVersion(v));
            }
            catch (Throwable t) {
                LoggerCreator.createLogger(SystemUtils.class).error("Failed to create version from " + version, t);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

