/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.image;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.scene.text.Font;
import org.eclipse.fx.core.Util;
import org.eclipse.fx.ui.controls.image.FontIconProvider;
import org.eclipse.jdt.annotation.NonNull;

public abstract class FontIcon {
    private static Map<String, FontIconProvider> PROVIDER_MAP = new HashMap<String, FontIconProvider>();
    public static final FontIcon UNKNOWN;

    static {
        PROVIDER_MAP.putAll(Util.lookupServiceList(FontIconProvider.class).stream().collect(Collectors.toMap(FontIconProvider::getNamespace, p -> p)));
        UNKNOWN = new FontIcon(){

            @Override
            public @NonNull String getIconName() {
                return "unknown";
            }

            @Override
            public char getIconCode() {
                return '?';
            }

            @Override
            public @NonNull Font getFont() {
                return Font.getDefault();
            }
        };
    }

    public abstract char getIconCode();

    public abstract @NonNull String getIconName();

    public abstract @NonNull Font getFont();

    FontIcon() {
    }

    public static Optional<FontIcon> create(final @NonNull String iconName) {
        FontIconProvider iconProvider;
        int idx = iconName.indexOf(45);
        if (idx > 0 && (iconProvider = PROVIDER_MAP.get(iconName.substring(0, idx))) != null) {
            return Optional.of(new FontIcon(){

                @Override
                public @NonNull Font getFont() {
                    return iconProvider.getFont();
                }

                @Override
                public char getIconCode() {
                    return iconProvider.map(iconName);
                }

                @Override
                public String getIconName() {
                    return iconName;
                }
            });
        }
        return Optional.empty();
    }
}

