/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.controlflow;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XSynchronizedExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.controlflow.EarlyExitInterpreter;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;

@Singleton
public class DefaultEarlyExitComputer
implements IEarlyExitComputer {
    @Inject
    private EarlyExitInterpreter earlyExitInterpreter;

    @Override
    public boolean isEarlyExit(XExpression expression) {
        Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(expression);
        boolean _isNotEmpty = this.isNotEmpty(exitPoints);
        return _isNotEmpty;
    }

    protected boolean isNotEmpty(Collection<IEarlyExitComputer.ExitPoint> exitPoints) {
        boolean _isEmpty;
        boolean _not;
        boolean _notEquals;
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal(exitPoints, null);
        _and = !_notEquals ? false : (_not = !(_isEmpty = exitPoints.isEmpty()));
        return _and;
    }

    @Override
    public Collection<IEarlyExitComputer.ExitPoint> getExitPoints(XExpression expression) {
        boolean _equals = Objects.equal((Object)expression, null);
        if (_equals) {
            return Collections.emptyList();
        }
        return this.exitPoints(expression);
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XExpression expression) {
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XReturnExpression expression) {
        IEarlyExitComputer.ExitPoint _exitPoint = new IEarlyExitComputer.ExitPoint(expression, false);
        return Collections.singletonList(_exitPoint);
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XThrowExpression expression) {
        IEarlyExitComputer.ExitPoint _exitPoint = new IEarlyExitComputer.ExitPoint(expression, true);
        return Collections.singletonList(_exitPoint);
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XBlockExpression expression) {
        EList<XExpression> _expressions = expression.getExpressions();
        for (XExpression child : _expressions) {
            Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(child);
            boolean _isNotEmpty = this.isNotEmpty(exitPoints);
            if (!_isNotEmpty) continue;
            return exitPoints;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XBasicForLoopExpression expression) {
        boolean _isBooleanConstant;
        EList<XExpression> _initExpressions = expression.getInitExpressions();
        for (XExpression initExpression : _initExpressions) {
            Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(initExpression);
            boolean _isNotEmpty = this.isNotEmpty(exitPoints);
            if (!_isNotEmpty) continue;
            return exitPoints;
        }
        XExpression predicate = expression.getExpression();
        Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(predicate);
        boolean _isNotEmpty = this.isNotEmpty(exitPoints);
        if (_isNotEmpty) {
            return exitPoints;
        }
        boolean _or = false;
        boolean _equals = Objects.equal((Object)predicate, null);
        _or = _equals ? true : (_isBooleanConstant = this.isBooleanConstant(predicate, true));
        if (_or) {
            XExpression _eachExpression = expression.getEachExpression();
            Collection<IEarlyExitComputer.ExitPoint> _exitPoints = this.getExitPoints(_eachExpression);
            exitPoints = _exitPoints;
            boolean _isNotEmpty_1 = this.isNotEmpty(exitPoints);
            if (_isNotEmpty_1) {
                return exitPoints;
            }
            EList<XExpression> _updateExpressions = expression.getUpdateExpressions();
            for (XExpression child : _updateExpressions) {
                Collection<IEarlyExitComputer.ExitPoint> _exitPoints_1 = this.getExitPoints(child);
                exitPoints = _exitPoints_1;
                boolean _isNotEmpty_2 = this.isNotEmpty(exitPoints);
                if (!_isNotEmpty_2) continue;
                return exitPoints;
            }
            IEarlyExitComputer.ExitPoint _exitPoint = new IEarlyExitComputer.ExitPoint(expression, false);
            return Collections.singletonList(_exitPoint);
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XForLoopExpression expression) {
        XExpression _forExpression = expression.getForExpression();
        Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(_forExpression);
        boolean _isNotEmpty = this.isNotEmpty(exitPoints);
        if (_isNotEmpty) {
            return exitPoints;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XWhileExpression expression) {
        XExpression _predicate = expression.getPredicate();
        Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(_predicate);
        boolean _isNotEmpty = this.isNotEmpty(exitPoints);
        if (_isNotEmpty) {
            return exitPoints;
        }
        XExpression _predicate_1 = expression.getPredicate();
        boolean _isBooleanConstant = this.isBooleanConstant(_predicate_1, true);
        if (_isBooleanConstant) {
            XExpression _body = expression.getBody();
            Collection<IEarlyExitComputer.ExitPoint> _exitPoints = this.getExitPoints(_body);
            exitPoints = _exitPoints;
            boolean _isNotEmpty_1 = this.isNotEmpty(exitPoints);
            if (_isNotEmpty_1) {
                return exitPoints;
            }
            IEarlyExitComputer.ExitPoint _exitPoint = new IEarlyExitComputer.ExitPoint(expression, false);
            return Collections.singletonList(_exitPoint);
        }
        return Collections.emptyList();
    }

    protected boolean isBooleanConstant(XExpression expression, boolean value) {
        return this.earlyExitInterpreter.isConstant(expression, value);
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XDoWhileExpression expression) {
        XExpression _body = expression.getBody();
        Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(_body);
        boolean _isNotEmpty = this.isNotEmpty(exitPoints);
        if (_isNotEmpty) {
            return exitPoints;
        }
        XExpression _predicate = expression.getPredicate();
        Collection<IEarlyExitComputer.ExitPoint> _exitPoints = this.getExitPoints(_predicate);
        exitPoints = _exitPoints;
        boolean _isNotEmpty_1 = this.isNotEmpty(exitPoints);
        if (_isNotEmpty_1) {
            return exitPoints;
        }
        XExpression _predicate_1 = expression.getPredicate();
        boolean _isBooleanConstant = this.isBooleanConstant(_predicate_1, true);
        if (_isBooleanConstant) {
            IEarlyExitComputer.ExitPoint _exitPoint = new IEarlyExitComputer.ExitPoint(expression, false);
            return Collections.singletonList(_exitPoint);
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XVariableDeclaration expression) {
        XExpression _right = expression.getRight();
        return this.getExitPoints(_right);
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XIfExpression expression) {
        boolean _isNotEmpty_2;
        XExpression _if = expression.getIf();
        Collection<IEarlyExitComputer.ExitPoint> ifExitPoints = this.getExitPoints(_if);
        boolean _isNotEmpty = this.isNotEmpty(ifExitPoints);
        if (_isNotEmpty) {
            return ifExitPoints;
        }
        XExpression _then = expression.getThen();
        Collection<IEarlyExitComputer.ExitPoint> thenExitPoints = this.getExitPoints(_then);
        XExpression _else = expression.getElse();
        Collection<IEarlyExitComputer.ExitPoint> elseExitPoints = this.getExitPoints(_else);
        boolean _and = false;
        boolean _isNotEmpty_1 = this.isNotEmpty(thenExitPoints);
        _and = !_isNotEmpty_1 ? false : (_isNotEmpty_2 = this.isNotEmpty(elseExitPoints));
        if (_and) {
            ArrayList result = Lists.newArrayList(thenExitPoints);
            result.addAll(elseExitPoints);
            return result;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XSwitchExpression expression) {
        boolean _not;
        XExpression _switch = expression.getSwitch();
        Collection<IEarlyExitComputer.ExitPoint> switchExitPoints = this.getExitPoints(_switch);
        boolean _isNotEmpty = this.isNotEmpty(switchExitPoints);
        if (_isNotEmpty) {
            return switchExitPoints;
        }
        ArrayList result = Lists.newArrayList();
        EList<XCasePart> _cases = expression.getCases();
        for (XCasePart casePart : _cases) {
            boolean _not2;
            boolean _notEquals;
            XExpression then = casePart.getThen();
            boolean bl = _notEquals = !Objects.equal((Object)then, null);
            if (!_notEquals) continue;
            Collection<IEarlyExitComputer.ExitPoint> caseExit = this.getExitPoints(then);
            boolean _isNotEmpty_1 = this.isNotEmpty(caseExit);
            boolean bl2 = _not2 = !_isNotEmpty_1;
            if (_not2) {
                return Collections.emptyList();
            }
            result.addAll(caseExit);
        }
        XExpression _default = expression.getDefault();
        Collection<IEarlyExitComputer.ExitPoint> defaultExit = this.getExitPoints(_default);
        boolean _isNotEmpty_1 = this.isNotEmpty(defaultExit);
        boolean bl = _not = !_isNotEmpty_1;
        if (_not) {
            return Collections.emptyList();
        }
        result.addAll(defaultExit);
        return result;
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XAbstractFeatureCall expression) {
        EList<XExpression> _actualArguments = expression.getActualArguments();
        for (XExpression argument : _actualArguments) {
            Collection<IEarlyExitComputer.ExitPoint> argumentExitPoints = this.getExitPoints(argument);
            boolean _isNotEmpty = this.isNotEmpty(argumentExitPoints);
            if (!_isNotEmpty) continue;
            return argumentExitPoints;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XConstructorCall expression) {
        EList<XExpression> _arguments = expression.getArguments();
        for (XExpression argument : _arguments) {
            Collection<IEarlyExitComputer.ExitPoint> argumentExitPoints = this.getExitPoints(argument);
            boolean _isNotEmpty = this.isNotEmpty(argumentExitPoints);
            if (!_isNotEmpty) continue;
            return argumentExitPoints;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XTryCatchFinallyExpression expression) {
        XExpression _expression = expression.getExpression();
        Collection<IEarlyExitComputer.ExitPoint> tryExitPoints = this.getExitPoints(_expression);
        boolean _isNotEmpty = this.isNotEmpty(tryExitPoints);
        if (_isNotEmpty) {
            ArrayList result = Lists.newArrayList(tryExitPoints);
            EList<XCatchClause> _catchClauses = expression.getCatchClauses();
            for (XCatchClause catchClause : _catchClauses) {
                XExpression _expression_1 = catchClause.getExpression();
                Collection<IEarlyExitComputer.ExitPoint> catchExitPoints = this.getExitPoints(_expression_1);
                boolean _isNotEmpty_1 = this.isNotEmpty(catchExitPoints);
                if (_isNotEmpty_1) {
                    result.addAll(catchExitPoints);
                    continue;
                }
                XExpression _finallyExpression = expression.getFinallyExpression();
                return this.getExitPoints(_finallyExpression);
            }
            return result;
        }
        XExpression _finallyExpression = expression.getFinallyExpression();
        return this.getExitPoints(_finallyExpression);
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XSynchronizedExpression expression) {
        XExpression _param = expression.getParam();
        Collection<IEarlyExitComputer.ExitPoint> paramExitPoints = this.getExitPoints(_param);
        boolean _isNotEmpty = this.isNotEmpty(paramExitPoints);
        if (_isNotEmpty) {
            return paramExitPoints;
        }
        XExpression _expression = expression.getExpression();
        return this.getExitPoints(_expression);
    }

    protected Collection<IEarlyExitComputer.ExitPoint> exitPoints(XExpression expression) {
        if (expression instanceof XDoWhileExpression) {
            return this._exitPoints((XDoWhileExpression)expression);
        }
        if (expression instanceof XWhileExpression) {
            return this._exitPoints((XWhileExpression)expression);
        }
        if (expression instanceof XAbstractFeatureCall) {
            return this._exitPoints((XAbstractFeatureCall)expression);
        }
        if (expression instanceof XBasicForLoopExpression) {
            return this._exitPoints((XBasicForLoopExpression)expression);
        }
        if (expression instanceof XBlockExpression) {
            return this._exitPoints((XBlockExpression)expression);
        }
        if (expression instanceof XConstructorCall) {
            return this._exitPoints((XConstructorCall)expression);
        }
        if (expression instanceof XForLoopExpression) {
            return this._exitPoints((XForLoopExpression)expression);
        }
        if (expression instanceof XIfExpression) {
            return this._exitPoints((XIfExpression)expression);
        }
        if (expression instanceof XReturnExpression) {
            return this._exitPoints((XReturnExpression)expression);
        }
        if (expression instanceof XSwitchExpression) {
            return this._exitPoints((XSwitchExpression)expression);
        }
        if (expression instanceof XSynchronizedExpression) {
            return this._exitPoints((XSynchronizedExpression)expression);
        }
        if (expression instanceof XThrowExpression) {
            return this._exitPoints((XThrowExpression)expression);
        }
        if (expression instanceof XTryCatchFinallyExpression) {
            return this._exitPoints((XTryCatchFinallyExpression)expression);
        }
        if (expression instanceof XVariableDeclaration) {
            return this._exitPoints((XVariableDeclaration)expression);
        }
        if (expression != null) {
            return this._exitPoints(expression);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expression).toString());
    }
}

