/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.Node;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.AnnotationPresenter;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.ISourceViewerExtension4;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class SourceViewer
extends TextViewer
implements ISourceViewer,
ISourceViewerExtension,
ISourceViewerExtension2,
ISourceViewerExtension3,
ISourceViewerExtension4 {
    private IPresentationReconciler fPresentationReconciler;
    private IReconciler fReconciler;
    private IAnnotationModel fVisualAnnotationModel;
    protected static final Object MODEL_ANNOTATION_MODEL = new Object();
    private Map<String, AnnotationPresenter> presenterMap = new HashMap<String, AnnotationPresenter>();
    private Annotation fRangeIndicator;

    @Override
    public void configure(SourceViewerConfiguration configuration) {
        IAnnotationModel annotationModel;
        IContentAssistant assist;
        if (this.getTextWidget() == null) {
            return;
        }
        this.getTextWidget().getStyleClass().add((Object)configuration.getStyleclassName());
        this.setDocumentPartitioning(configuration.getConfiguredDocumentPartitioning(this));
        this.fPresentationReconciler = configuration.getPresentationReconciler(this);
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.install(this);
        }
        this.fReconciler = configuration.getReconciler(this);
        if (this.fReconciler != null) {
            this.fReconciler.install(this);
        }
        if ((assist = configuration.getContentAssist()) != null) {
            assist.install(this);
        }
        if ((annotationModel = configuration.getAnnotationModel()) != null) {
            this.getTextWidget().setLineRulerGraphicNodeFactory(this::annotationFactory);
            annotationModel.addAnnotationModelListener(new IAnnotationModelListener(){
                private boolean scheduled = false;

                public void modelChanged(IAnnotationModel model) {
                    if (!this.scheduled) {
                        this.scheduled = true;
                        Platform.runLater(() -> {
                            this.scheduled = false;
                            SourceViewer.this.getTextWidget().refreshLineRuler();
                        });
                    }
                }
            });
        }
        if (configuration.getAnnotationPresenters() != null) {
            configuration.getAnnotationPresenters().stream().forEach(p -> p.getTypes().forEach(s -> {
                AnnotationPresenter annotationPresenter2 = this.presenterMap.put((String)s, (AnnotationPresenter)p);
            }));
        }
        AnnotationPainter annotationPainter = configuration.getAnnotationPainter(this);
        if (annotationModel != null && annotationPainter != null) {
            annotationModel.addAnnotationModelListener((IAnnotationModelListener)annotationPainter);
            this.addTextPresentationListener(annotationPainter);
        }
    }

    private Node annotationFactory(StyledTextArea.StyledTextLine l) {
        Iterator annotationIterator = this.fVisualAnnotationModel.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            Annotation a = (Annotation)annotationIterator.next();
            Position position = this.fVisualAnnotationModel.getPosition(a);
            if (l.getLineIndex() != this.getTextWidget().getContent().getLineAtOffset(position.offset)) continue;
            AnnotationPresenter annotationPresenter = this.presenterMap.get(a.getType());
            if (annotationPresenter != null) {
                return annotationPresenter.getPresentation(a);
            }
            return null;
        }
        return null;
    }

    protected void disposeVisualAnnotationModel() {
        if (this.fVisualAnnotationModel != null) {
            if (this.getDocument() != null) {
                this.fVisualAnnotationModel.disconnect(this.getDocument());
            }
            if (this.fVisualAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fVisualAnnotationModel).removeAnnotationModel(MODEL_ANNOTATION_MODEL);
            }
            this.fVisualAnnotationModel = null;
        }
    }

    protected IAnnotationModel createVisualAnnotationModel(IAnnotationModel annotationModel) {
        AnnotationModel model = new AnnotationModel();
        model.addAnnotationModel(MODEL_ANNOTATION_MODEL, annotationModel);
        return (IAnnotationModel)model;
    }

    @Override
    public void setDocument(IDocument document, IAnnotationModel annotationModel) {
        this.setDocument(document, annotationModel, -1, -1);
    }

    @Override
    public void setDocument(IDocument document, IAnnotationModel annotationModel, int modelRangeOffset, int modelRangeLength) {
        this.disposeVisualAnnotationModel();
        if (annotationModel != null && document != null) {
            this.fVisualAnnotationModel = this.createVisualAnnotationModel(annotationModel);
            if (annotationModel instanceof ISynchronizable && this.fVisualAnnotationModel instanceof ISynchronizable) {
                ISynchronizable sync = (ISynchronizable)this.fVisualAnnotationModel;
                sync.setLockObject(((ISynchronizable)annotationModel).getLockObject());
            }
            this.fVisualAnnotationModel.connect(document);
        }
        if (modelRangeOffset == -1 && modelRangeLength == -1) {
            super.setDocument(document);
        } else {
            super.setDocument(document, modelRangeOffset, modelRangeLength);
        }
    }

    @Override
    public IAnnotationModel getAnnotationModel() {
        if (this.fVisualAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension extension = (IAnnotationModelExtension)this.fVisualAnnotationModel;
            return extension.getAnnotationModel(MODEL_ANNOTATION_MODEL);
        }
        return null;
    }

    @Override
    public IAnnotationModel getVisualAnnotationModel() {
        return this.fVisualAnnotationModel;
    }

    public void setRangeIndicator(Annotation rangeIndicator) {
        this.fRangeIndicator = rangeIndicator;
    }

    public IRegion getRangeIndication() {
        Position position;
        if (this.fRangeIndicator != null && this.fVisualAnnotationModel != null && (position = this.fVisualAnnotationModel.getPosition(this.fRangeIndicator)) != null) {
            return new Region(position.getOffset(), position.getLength());
        }
        return null;
    }
}

