/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import java.util.List;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.ITextSegment;
import org.eclipse.xtext.formatting2.internal.CommentReplacer;
import org.eclipse.xtext.formatting2.internal.WhitespaceReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;

public class MultilineCommentReplacer
extends CommentReplacer {
    private final boolean multiline;
    private final char prefix;

    public MultilineCommentReplacer(IComment comment, char prefix) {
        super(comment);
        this.prefix = prefix;
        this.multiline = comment.isMultiline();
    }

    @Override
    public void configureWhitespace(WhitespaceReplacer leading, WhitespaceReplacer trailing) {
        if (this.multiline) {
            this.enforceNewLine(leading);
            this.enforceNewLine(trailing);
        } else {
            this.enforceSingleSpace(leading);
            this.enforceSingleSpace(trailing);
        }
    }

    @Override
    public ITextReplacerContext createReplacements(ITextReplacerContext context) {
        if (!this.multiline) {
            return context;
        }
        IComment comment = this.getComment();
        String oldIndentation = comment.getIndentation().getText();
        String indentationString = context.getIndentationString();
        String newIndentation = String.valueOf(indentationString) + " " + this.prefix + " ";
        List<ITextSegment> lines = comment.splitIntoLines();
        int i = 1;
        while (i < lines.size() - 1) {
            ITextSegment line = lines.get(i);
            String text = line.getText();
            int prefixOffset = this.prefixOffset(text);
            if (prefixOffset >= 0) {
                context.replaceText(line.getOffset(), prefixOffset + 1, newIndentation);
            } else if (text.startsWith(oldIndentation)) {
                context.replaceText(line.getOffset(), oldIndentation.length(), newIndentation);
            } else {
                context.replaceText(line.getOffset(), 0, newIndentation);
            }
            ++i;
        }
        if (lines.size() > 1) {
            ITextSegment line = lines.get(lines.size() - 1);
            context.replaceText(line.getIndentation(), String.valueOf(indentationString) + " ");
        }
        return context;
    }

    protected void enforceNewLine(WhitespaceReplacer replacer) {
        if (replacer.getRegion().getOffset() <= 0) {
            return;
        }
        Integer min = replacer.getFormatting().getNewLineMin();
        if (min == null || min < 1) {
            replacer.getFormatting().setNewLinesMin(1);
        }
    }

    protected void enforceSingleSpace(WhitespaceReplacer replacer) {
        if (replacer.getRegion().getOffset() <= 0) {
            return;
        }
        String space = replacer.getFormatting().getSpace();
        if (space == null || space.length() < 1) {
            replacer.getFormatting().setSpace(" ");
        }
    }

    protected int prefixOffset(String string) {
        int i = 0;
        while (i < string.length()) {
            char charAt = string.charAt(i);
            if (this.prefix == charAt) {
                int j = i + 1;
                if (j < string.length() && Character.isWhitespace(string.charAt(j))) {
                    return j;
                }
                return i;
            }
            if (!Character.isWhitespace(charAt)) {
                return -1;
            }
            ++i;
        }
        return -1;
    }
}

