/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property;

import java.util.Map;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.map.MapProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.identity.IdentityMap;
import org.eclipse.core.internal.databinding.property.PropertyObservableUtil;

public class MapPropertyDetailValuesMap
extends MapProperty {
    private final IMapProperty masterProperty;
    private final IValueProperty detailProperty;

    public MapPropertyDetailValuesMap(IMapProperty masterProperty, IValueProperty detailProperty) {
        this.masterProperty = masterProperty;
        this.detailProperty = detailProperty;
    }

    @Override
    public Object getKeyType() {
        return this.masterProperty.getKeyType();
    }

    @Override
    public Object getValueType() {
        return this.detailProperty.getValueType();
    }

    @Override
    protected Map doGetMap(Object source) {
        Map masterMap = this.masterProperty.getMap(source);
        IdentityMap detailMap = new IdentityMap();
        for (Map.Entry entry : masterMap.entrySet()) {
            detailMap.put(entry.getKey(), this.detailProperty.getValue(entry.getValue()));
        }
        return detailMap;
    }

    @Override
    protected void doUpdateMap(Object source, MapDiff diff) {
        if (!diff.getAddedKeys().isEmpty()) {
            throw new UnsupportedOperationException(String.valueOf(this.toString()) + " does not support entry additions");
        }
        if (!diff.getRemovedKeys().isEmpty()) {
            throw new UnsupportedOperationException(String.valueOf(this.toString()) + " does not support entry removals");
        }
        Map masterMap = this.masterProperty.getMap(source);
        for (Object key : diff.getChangedKeys()) {
            Object masterValue = masterMap.get(key);
            this.detailProperty.setValue(masterValue, diff.getNewValue(key));
        }
    }

    @Override
    public IObservableMap observe(Realm realm, Object source) {
        IObservableMap masterMap;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterMap = this.masterProperty.observe(realm, source);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableMap detailMap = this.detailProperty.observeDetail(masterMap);
        PropertyObservableUtil.cascadeDispose((IObservable)detailMap, (IObservable)masterMap);
        return detailMap;
    }

    @Override
    public IObservableMap observeDetail(IObservableValue master) {
        IObservableMap masterMap;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterMap = this.masterProperty.observeDetail(master);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableMap detailMap = this.detailProperty.observeDetail(masterMap);
        PropertyObservableUtil.cascadeDispose((IObservable)detailMap, (IObservable)masterMap);
        return detailMap;
    }

    public String toString() {
        return this.masterProperty + " => " + this.detailProperty;
    }
}

