/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.ldef.langs.text;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.code.editor.ldef.LDefStandaloneSetup;
import org.eclipse.fx.code.editor.ldef.lDef.LanguageDef;
import org.eclipse.fx.code.editor.ldef.lDef.Root;
import org.eclipse.fx.code.editor.ldef.text.LDefModelProvider;
import org.eclipse.fx.code.editor.services.URIProvider;
import org.osgi.service.component.annotations.Component;

@Component(service={LDefModelProvider.class, LDefDefaultModelProvider.class})
public class LDefDefaultModelProvider
implements LDefModelProvider {
    private final Map<String, URI> definitionURI = new HashMap<String, URI>();
    private final Map<String, LanguageDef> definitionCache = new HashMap<String, LanguageDef>();
    private ResourceSetImpl rs;

    public LDefDefaultModelProvider() {
        LDefStandaloneSetup.doSetup();
        this.rs = new ResourceSetImpl();
        this.register(URI.createURI((String)"platform:/plugin/org.eclipse.fx.code.editor.ldef.langs/org/eclipse/fx/code/editor/ldef/langs/dart/dart.ldef"), "dart");
        this.register(URI.createURI((String)"platform:/plugin/org.eclipse.fx.code.editor.ldef.langs/org/eclipse/fx/code/editor/ldef/langs/js/js.ldef"), "js");
        this.register(URI.createURI((String)"platform:/plugin/org.eclipse.fx.code.editor.ldef.langs/org/eclipse/fx/code/editor/ldef/langs/java/java.ldef"), "java");
        this.register(URI.createURI((String)"platform:/plugin/org.eclipse.fx.code.editor.ldef.langs/org/eclipse/fx/code/editor/ldef/langs/xml/xml.ldef"), "xml");
        this.register(URI.createURI((String)"platform:/plugin/org.eclipse.fx.code.editor.ldef.langs/org/eclipse/fx/code/editor/ldef/langs/go/go.ldef"), "go");
        this.register(URI.createURI((String)"platform:/plugin/org.eclipse.fx.code.editor.ldef.langs/org/eclipse/fx/code/editor/ldef/langs/rust/rust.ldef"), "rust");
        this.register(URI.createURI((String)"platform:/plugin/org.eclipse.fx.code.editor.ldef.langs/org/eclipse/fx/code/editor/ldef/langs/swift/swift.ldef"), "swift");
        this.register(URI.createURI((String)"platform:/plugin/org.eclipse.fx.code.editor.ldef.langs/org/eclipse/fx/code/editor/ldef/langs/groovy/groovy.ldef"), "groovy");
        this.register(URI.createURI((String)"platform:/plugin/org.eclipse.fx.code.editor.ldef.langs/org/eclipse/fx/code/editor/ldef/langs/python/python.ldef"), "python");
        this.register(URI.createURI((String)"platform:/plugin/org.eclipse.fx.code.editor.ldef.langs/org/eclipse/fx/code/editor/ldef/langs/python/php.ldef"), "php");
    }

    private void register(URI uri, String fileSuffix) {
        this.definitionURI.put(fileSuffix, uri);
    }

    public boolean applies(Input<?> input) {
        org.eclipse.fx.core.URI uri;
        String lastSegment;
        int idx;
        if (input instanceof URIProvider && (idx = (lastSegment = (uri = ((URIProvider)input).getURI()).lastSegment()).lastIndexOf(46)) != -1) {
            return this.definitionURI.containsKey(lastSegment.substring(idx + 1));
        }
        return false;
    }

    public LanguageDef getModel(Input<?> input) {
        org.eclipse.fx.core.URI uri;
        String lastSegment;
        int idx;
        if (input instanceof URIProvider && (idx = (lastSegment = (uri = ((URIProvider)input).getURI()).lastSegment()).lastIndexOf(46)) != -1) {
            return this.getModelByExtension(lastSegment.substring(idx + 1));
        }
        return null;
    }

    public LanguageDef getModelByExtension(String extension) {
        LanguageDef def = this.definitionCache.get(extension);
        if (def == null) {
            Resource resource = this.rs.getResource(this.definitionURI.get(extension), true);
            def = ((Root)resource.getContents().get(0)).getLanguageDefinition();
            this.definitionCache.put(extension, def);
        }
        return def;
    }
}

