/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.panes;

import java.util.WeakHashMap;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.WritableBooleanValue;
import javafx.beans.value.WritableIntegerValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import org.eclipse.fx.ui.panes.AbstractLayoutPane;

public class FillLayoutPane
extends AbstractLayoutPane<FillData> {
    private WritableBooleanValue horizontal = new SimpleBooleanProperty((Object)this, "horizontal", true);
    private WritableIntegerValue marginWidth = new SimpleIntegerProperty((Object)this, "marginWidth", 0);
    private WritableIntegerValue marginHeight = new SimpleIntegerProperty((Object)this, "marginHeight", 0);
    private WritableIntegerValue spacing = new SimpleIntegerProperty((Object)this, "spacing", 0);
    private static WeakHashMap<Node, FillData> CONSTRAINTS = new WeakHashMap();

    public static void setConstraint(Node n, FillData griddata) {
        CONSTRAINTS.put(n, griddata);
    }

    public static FillData getConstraint(Node n) {
        return CONSTRAINTS.get(n);
    }

    public void setHorizontal(boolean horizontal) {
        this.horizontal.set(horizontal);
    }

    public boolean isHorizontal() {
        return this.horizontal.get();
    }

    public WritableBooleanValue horizontalProperty() {
        return this.horizontal;
    }

    public void setMarginWidth(int marginWidth) {
        this.marginWidth.set(marginWidth);
    }

    public int getMarginWidth() {
        return this.marginWidth.get();
    }

    public WritableIntegerValue marginHeightProperty() {
        return this.marginHeight;
    }

    public void setMarginHeight(int marginHeight) {
        this.marginHeight.set(marginHeight);
    }

    public int getMarginHeight() {
        return this.marginHeight.get();
    }

    public WritableIntegerValue marginWidthProperty() {
        return this.marginWidth;
    }

    @Override
    protected AbstractLayoutPane.Size computeSize(double wHint, double hHint, boolean flushCache) {
        Node[] children = (Node[])this.getChildren().toArray((Object[])new Node[0]);
        int count = children.length;
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        int i = 0;
        while (i < count) {
            Node child = children[i];
            double w = wHint;
            double h = hHint;
            if (count > 0) {
                if (this.horizontal.get() && wHint != -1.0) {
                    w = Math.max(0.0, (wHint - (double)((count - 1) * this.spacing.get())) / (double)count);
                }
                if (!this.horizontal.get() && hHint != -1.0) {
                    h = Math.max(0.0, (hHint - (double)((count - 1) * this.spacing.get())) / (double)count);
                }
            }
            AbstractLayoutPane.Size size = this.computeChildSize(child, w, h, flushCache);
            maxWidth = Math.max(maxWidth, size.width);
            maxHeight = Math.max(maxHeight, size.height);
            ++i;
        }
        double width = 0.0;
        double height = 0.0;
        if (this.horizontal.get()) {
            width = (double)count * maxWidth;
            if (count != 0) {
                width += (double)((count - 1) * this.spacing.get());
            }
            height = maxHeight;
        } else {
            width = maxWidth;
            height = (double)count * maxHeight;
            if (count != 0) {
                height += (double)((count - 1) * this.spacing.get());
            }
        }
        width += (double)(this.marginWidth.get() * 2);
        height += (double)(this.marginHeight.get() * 2);
        if (wHint != -1.0) {
            width = wHint;
        }
        if (hHint != -1.0) {
            height = hHint;
        }
        return new AbstractLayoutPane.Size(width, height);
    }

    AbstractLayoutPane.Size computeChildSize(Node control, double wHint, double hHint, boolean flushCache) {
        FillData data = FillLayoutPane.getConstraint(control);
        if (data == null) {
            data = new FillData();
            FillLayoutPane.setConstraint(control, data);
        }
        AbstractLayoutPane.Size size = null;
        if (wHint == -1.0 && hHint == -1.0) {
            size = data.computeSize(control, wHint, hHint, flushCache);
        } else {
            boolean trimY = false;
            boolean trimX = false;
            double w = wHint == -1.0 ? wHint : Math.max(0.0, wHint - (double)trimX);
            double h = hHint == -1.0 ? hHint : Math.max(0.0, hHint - (double)trimY);
            size = data.computeSize(control, w, h, flushCache);
        }
        return size;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        Bounds rect = this.getLayoutBounds();
        Node[] children = (Node[])this.getChildren().toArray((Object[])new Node[0]);
        int count = children.length;
        if (count == 0) {
            return;
        }
        double width = rect.getWidth() - (double)(this.marginWidth.get() * 2);
        double height = rect.getHeight() - (double)(this.marginHeight.get() * 2);
        if (this.horizontal.get()) {
            double x = rect.getMinX() + (double)this.marginWidth.get();
            double extra = (width -= (double)((count - 1) * this.spacing.get())) % (double)count;
            double y = rect.getMinY() + (double)this.marginHeight.get();
            double cellWidth = width / (double)count;
            int i = 0;
            while (i < count) {
                Node child = children[i];
                double childWidth = cellWidth;
                if (i == 0) {
                    childWidth += extra / 2.0;
                } else if (i == count - 1) {
                    childWidth += (extra + 1.0) / 2.0;
                }
                child.resizeRelocate(x, y, childWidth, height);
                x += childWidth + (double)this.spacing.get();
                ++i;
            }
        } else {
            double x = rect.getMinX() + (double)this.marginWidth.get();
            double cellHeight = (height -= (double)((count - 1) * this.spacing.get())) / (double)count;
            double y = rect.getMinY() + (double)this.marginHeight.get();
            double extra = height % (double)count;
            int i = 0;
            while (i < count) {
                Node child = children[i];
                double childHeight = cellHeight;
                if (i == 0) {
                    childHeight += extra / 2.0;
                } else if (i == count - 1) {
                    childHeight += (extra + 1.0) / 2.0;
                }
                child.resizeRelocate(x, y, width, childHeight);
                y += childHeight + (double)this.spacing.get();
                ++i;
            }
        }
    }

    static class FillData {
        double defaultWidth = -1.0;
        double defaultHeight = -1.0;
        double currentWhint;
        double currentHhint;
        double currentWidth = -1.0;
        double currentHeight = -1.0;

        FillData() {
        }

        AbstractLayoutPane.Size computeSize(Node control, double wHint, double hHint, boolean flushCache) {
            if (flushCache) {
                this.flushCache();
            }
            if (wHint == -1.0 && hHint == -1.0) {
                if (this.defaultWidth == -1.0 || this.defaultHeight == -1.0) {
                    this.defaultWidth = control.prefWidth(hHint);
                    this.defaultHeight = control.prefHeight(wHint);
                }
                return new AbstractLayoutPane.Size(this.defaultWidth, this.defaultHeight);
            }
            if (this.currentWidth == -1.0 || this.currentHeight == -1.0 || wHint != this.currentWhint || hHint != this.currentHhint) {
                this.currentWhint = wHint;
                this.currentHhint = hHint;
                this.currentWidth = control.getLayoutBounds().getWidth();
                this.currentHeight = control.getLayoutBounds().getHeight();
            }
            return new AbstractLayoutPane.Size(this.currentWidth, this.currentHeight);
        }

        void flushCache() {
            this.defaultHeight = -1.0;
            this.defaultWidth = -1.0;
            this.currentHeight = -1.0;
            this.currentWidth = -1.0;
        }
    }
}

