/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.text.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.fx.code.editor.configuration.Partition;
import org.eclipse.fx.code.editor.configuration.PartitionRule;
import org.eclipse.fx.code.editor.configuration.PartitionRule_DynamicEnd;
import org.eclipse.fx.code.editor.configuration.PartitionRule_JavaScript;
import org.eclipse.fx.code.editor.configuration.PartitionRule_MultiLine;
import org.eclipse.fx.code.editor.configuration.PartitionRule_SingleLine;
import org.eclipse.fx.code.editor.configuration.text.Util;
import org.eclipse.fx.core.NamedValue;
import org.eclipse.fx.text.rules.DynamicEndRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class ConfigurationRuleBasedPartitionScanner
extends RuleBasedPartitionScanner {
    public ConfigurationRuleBasedPartitionScanner(List<Partition> paritioner, Map<String, NamedValue<Object>> values) {
        ArrayList<IPredicateRule> pr = new ArrayList<IPredicateRule>();
        for (Partition p : paritioner) {
            for (PartitionRule r : p.getRuleList()) {
                String escapeSeq;
                String endSeq;
                if (!Util.checkCondition(r.getCondition(), values)) continue;
                if (r instanceof PartitionRule_SingleLine) {
                    PartitionRule_SingleLine sr = (PartitionRule_SingleLine)r;
                    endSeq = sr.getEndSeq();
                    escapeSeq = sr.getEscapedBy();
                    pr.add((IPredicateRule)Util.wrap(r.getCheck(), (IRule)new SingleLineRule(sr.getStartSeq(), endSeq, (IToken)new Token((Object)p.getName()), escapeSeq != null ? escapeSeq.charAt(0) : (char)'\u0000', true)));
                    continue;
                }
                if (r instanceof PartitionRule_MultiLine) {
                    PartitionRule_MultiLine mr = (PartitionRule_MultiLine)r;
                    endSeq = mr.getEndSeq();
                    escapeSeq = mr.getEscapedBy();
                    pr.add((IPredicateRule)Util.wrap(r.getCheck(), (IRule)new MultiLineRule(mr.getStartSeq(), endSeq, (IToken)new Token((Object)p.getName()), escapeSeq != null ? escapeSeq.charAt(0) : (char)'\u0000', true)));
                    continue;
                }
                if (r instanceof PartitionRule_JavaScript) {
                    PartitionRule_JavaScript jr = (PartitionRule_JavaScript)r;
                    try {
                        ScriptEngineManager engineManager = new ScriptEngineManager();
                        ScriptEngine engine = engineManager.getEngineByName("nashorn");
                        pr.add((IPredicateRule)Util.wrap(jr.getCheck(), (IRule)((IPredicateRule)engine.eval(jr.getScript()))));
                    }
                    catch (ScriptException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(r instanceof PartitionRule_DynamicEnd)) continue;
                PartitionRule_DynamicEnd pde = (PartitionRule_DynamicEnd)r;
                pr.add((IPredicateRule)Util.wrap(r.getCheck(), (IRule)new DynamicEndRule((IToken)new Token((Object)p.getName()), pde.getBeginPrefix(), Pattern.compile(pde.getBeginMatch()), pde.getBeginSuffix(), pde.getEndTemplate())));
            }
        }
        this.setPredicateRules(pr.toArray(new IPredicateRule[0]));
    }
}

