/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.backend;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.fx.drift.internal.GL;
import org.eclipse.fx.drift.internal.jni.win32.NVDXInterop;
import org.eclipse.fx.drift.internal.jni.win32.Win32;
import org.eclipse.fx.drift.internal.jni.win32.WindowsError;

public class NVDXInteropDevice {
    public final Win32.HANDLE hDevice;
    private Win32.IDirect3DDevice9Ex dxDevice;
    private long glContext;
    private int usageCount = 0;
    private static List<NVDXInteropDevice> devices = new ArrayList<NVDXInteropDevice>();

    private NVDXInteropDevice(Win32.HANDLE hDevice) {
        this.hDevice = hDevice;
    }

    public String toString() {
        return "NVDXInteropDevice " + this.hDevice + " / " + this.dxDevice + " / " + this.glContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NVDXInteropDevice openDevice(Win32.IDirect3DDevice9Ex dxDevice) throws WindowsError {
        List<NVDXInteropDevice> list = devices;
        synchronized (list) {
            long glContext = GL.getCurrentContext();
            NVDXInteropDevice device = null;
            Optional<NVDXInteropDevice> existing = devices.stream().filter(dev -> dev.glContext == glContext && dev.dxDevice.address == dxDevice.address).findFirst();
            if (existing.isPresent()) {
                device = existing.get();
            } else {
                device = new NVDXInteropDevice(NVDXInterop.wglDXOpenDeviceNV(dxDevice));
                device.glContext = glContext;
                device.dxDevice = dxDevice;
                devices.add(device);
            }
            ++device.usageCount;
            System.err.println(device);
            return device;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDevice() throws WindowsError {
        List<NVDXInteropDevice> list = devices;
        synchronized (list) {
            --this.usageCount;
            if (this.usageCount == 0) {
                NVDXInterop.wglDXCloseDeviceNV(this.hDevice);
                devices.remove(this);
            }
        }
    }
}

