/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.tabpages.testset;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.titan.executor.tabpages.testset.TestCaseTreeElement;
import org.eclipse.titan.executor.tabpages.testset.TestcaseTransfer;
import org.eclipse.titan.executor.tabpages.testset.TestsetTreeElement;

public final class TestsetTreeDragSourceListener
implements DragSourceListener {
    private final TreeViewer testsetViewer;

    public TestsetTreeDragSourceListener(TreeViewer testsetViewer) {
        this.testsetViewer = testsetViewer;
    }

    public void dragFinished(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.testsetViewer.getSelection();
        if (!selection.isEmpty()) {
            this.testsetViewer.getTree().setRedraw(false);
            if (event.detail == 2) {
                for (Object element : selection) {
                    if (!(element instanceof TestCaseTreeElement)) continue;
                    ((TestsetTreeElement)((TestCaseTreeElement)element).parent()).remove((TestCaseTreeElement)element);
                    ((TestCaseTreeElement)element).dispose();
                }
            }
            this.testsetViewer.getTree().setRedraw(true);
            this.testsetViewer.refresh();
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (TestcaseTransfer.getInstance().isSupportedType(event.dataType)) {
            IStructuredSelection selection = (IStructuredSelection)this.testsetViewer.getSelection();
            ArrayList<TestCaseTreeElement> testcases = new ArrayList<TestCaseTreeElement>();
            if (!selection.isEmpty()) {
                for (Object element : selection) {
                    if (!(element instanceof TestCaseTreeElement)) continue;
                    testcases.add((TestCaseTreeElement)element);
                }
                event.data = testcases.toArray(new TestCaseTreeElement[testcases.size()]);
            }
        }
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.testsetViewer.getSelection();
        event.doit = !selection.isEmpty() && !(selection.getFirstElement() instanceof TestsetTreeElement);
    }
}

