/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.details;

import java.text.StringCharacterIterator;
import java.util.Map;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.utils.StringUtils;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.preferences.PreferencesHandler;
import org.eclipse.titan.log.viewer.preferences.PreferencesHolder;
import org.eclipse.titan.log.viewer.views.details.DetailData;

public class TextViewComposite
extends Composite {
    private StyledText styledText = new StyledText((Composite)this, 776);
    private String currentText;
    private String currentName;
    private boolean useFormatting;
    private Font font = Display.getCurrent().getSystemFont();
    private LogFileMetaData logFileMetaData;

    public TextViewComposite(Composite parent) {
        super(parent, 262144);
        this.styledText.setFont(this.font);
        this.useFormatting = true;
    }

    public void dispose() {
        if (this.styledText != null && !this.styledText.isDisposed()) {
            this.styledText.dispose();
        }
        if (this.font != null && !this.font.isDisposed()) {
            this.font.dispose();
        }
        super.dispose();
    }

    public void setUseFormatting(boolean useFormatting) {
        this.useFormatting = useFormatting;
    }

    public void inputChanged(DetailData newInput) {
        if (newInput == null) {
            this.clearText();
            return;
        }
        String newText = newInput.getLine();
        String newName = newInput.getName();
        if (StringUtils.isNullOrEmpty((String)newText)) {
            this.currentText = null;
            this.styledText.setText("");
            return;
        }
        if (StringUtils.isNullOrEmpty((String)newName)) {
            this.currentName = null;
        }
        if (this.currentText != null && this.currentText.contentEquals(newText) && this.currentName != null && this.currentName.equals(newName)) {
            return;
        }
        this.currentText = newText = this.removeEndingColon(newText);
        this.currentName = newName;
        int newLineIndex = this.currentText.indexOf("\n");
        boolean hasNewLine = newLineIndex >= 0 && newLineIndex != this.currentText.length() - 1;
        String text = this.formatText(newInput, hasNewLine);
        String messageText = newInput.getSourceInfo().trim() + "\n" + text;
        this.styledText.setText(messageText);
        this.colorKeywords(text, messageText);
    }

    private void colorKeywords(String text, String messageText) {
        PreferencesHolder preferences = PreferencesHandler.getInstance().getPreferences(this.logFileMetaData.getProjectName());
        boolean useKeywordColoring = preferences.getUseColoringKeywords();
        if (useKeywordColoring) {
            Map<String, RGB> coloringKeywords = preferences.getColoringKeywords();
            for (Map.Entry<String, RGB> entry : coloringKeywords.entrySet()) {
                String currentKeyword = entry.getKey();
                int messagePosition = messageText.indexOf(text);
                int startPosition = messageText.indexOf(currentKeyword, messagePosition);
                while (startPosition > -1) {
                    Color textColor = (Color)Activator.getDefault().getCachedResource(entry.getValue());
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = startPosition;
                    styleRange.length = currentKeyword.length();
                    styleRange.foreground = textColor;
                    styleRange.strikeout = false;
                    styleRange.underline = false;
                    this.styledText.setStyleRange(styleRange);
                    startPosition = messageText.indexOf(currentKeyword, startPosition + currentKeyword.length());
                }
            }
        }
    }

    private String formatText(DetailData newInput, boolean hasNewLine) {
        if (!this.useFormatting || hasNewLine) {
            return this.currentText;
        }
        StringBuilder text = new StringBuilder();
        String port = newInput.getPort();
        if (port != null && port.trim().length() > 0) {
            text.append(newInput.getName());
            text.append("(");
            text.append(newInput.getPort());
            text.append(") ");
        } else {
            text.setLength(0);
            text.append(newInput.getName());
            text.append(" ");
        }
        int startBracket = 123;
        if (!this.currentText.contains("{")) {
            text.append(this.currentText);
        } else {
            int endBracket = 125;
            int comma = 44;
            String newLine = "\n";
            String spaces = "  ";
            String indent = "";
            StringCharacterIterator ci = new StringCharacterIterator(this.currentText);
            char currentChar = ci.first();
            while (currentChar != '\uffff') {
                switch (currentChar) {
                    case '{': {
                        indent = indent + "  ";
                        text.append('{');
                        text.append("\n");
                        text.append(indent.substring(0, indent.length() - 1));
                        break;
                    }
                    case '}': {
                        if (indent.length() - "  ".length() > 0) {
                            indent = indent.substring(0, indent.length() - "  ".length());
                        }
                        text.append("\n");
                        text.append(indent);
                        text.append('}');
                        break;
                    }
                    case ',': {
                        if (indent.length() > 1) {
                            text.append(currentChar);
                            text.append("\n");
                            text.append(indent.substring(0, indent.length() - 1));
                            break;
                        }
                        text.append(currentChar);
                        text.append("\n");
                        break;
                    }
                    default: {
                        text.append(currentChar);
                    }
                }
                currentChar = ci.next();
            }
        }
        return text.toString();
    }

    private String removeEndingColon(String newText) {
        if (newText.length() >= 2 && newText.startsWith(": ")) {
            return newText.substring(2);
        }
        return newText;
    }

    private void clearText() {
        this.currentText = null;
        this.currentName = null;
        this.styledText.setText("");
    }

    public LogFileMetaData getLogFileMetaData() {
        return this.logFileMetaData;
    }

    public void setLogFileMetaData(LogFileMetaData logFileMetaData) {
        this.logFileMetaData = logFileMetaData;
    }
}

