/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers.ttcn3parser;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITTCN3ReparseBase;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITtcn3FileReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;

public class Ttcn3FileReparser
implements ITtcn3FileReparser {
    private final TTCN3ReparseUpdater mReparser;
    private final IFile mFile;
    private final ProjectSourceParser mSourceParser;
    private final Map<IFile, String> mFileMap;
    private final Map<IFile, String> mUptodateFiles;
    private final Set<IFile> mHighlySyntaxErroneousFiles;
    private boolean mSyntacticallyOutdated = false;

    public Ttcn3FileReparser(TTCN3ReparseUpdater aReparser, IFile aFile, ProjectSourceParser aSourceParser, Map<IFile, String> aFileMap, Map<IFile, String> aUptodateFiles, Set<IFile> aHighlySyntaxErroneousFiles) {
        this.mReparser = aReparser;
        this.mFile = aFile;
        this.mSourceParser = aSourceParser;
        this.mFileMap = aFileMap;
        this.mUptodateFiles = aUptodateFiles;
        this.mHighlySyntaxErroneousFiles = aHighlySyntaxErroneousFiles;
    }

    @Override
    public boolean parse() {
        this.mReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                parser.pr_TTCN3File();
                TTCN3Module actualTtcn3Module = parser.getModule();
                if (actualTtcn3Module != null && actualTtcn3Module.getIdentifier() != null) {
                    Ttcn3FileReparser.this.mSourceParser.getSemanticAnalyzer().addModule(actualTtcn3Module);
                    Ttcn3FileReparser.this.mFileMap.put(Ttcn3FileReparser.this.mFile, actualTtcn3Module.getName());
                    Ttcn3FileReparser.this.mUptodateFiles.put(Ttcn3FileReparser.this.mFile, actualTtcn3Module.getName());
                } else {
                    Ttcn3FileReparser.this.mSyntacticallyOutdated = true;
                    Ttcn3FileReparser.this.mHighlySyntaxErroneousFiles.add(Ttcn3FileReparser.this.mFile);
                }
                if (actualTtcn3Module.getLocation().getEndOffset() == -1 && !parser.getErrors().isEmpty()) {
                    actualTtcn3Module.getLocation().setEndOffset((int)new File(Ttcn3FileReparser.this.mFile.getLocationURI()).length());
                }
            }
        });
        return this.mSyntacticallyOutdated;
    }
}

