/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Group;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ImportModule;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.OutlineViewSorter;
import org.eclipse.titan.designer.editors.ttcn3editor.OutlineContentProvider;
import org.eclipse.titan.designer.editors.ttcn3editor.OutlineLabelProvider;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public final class OutlinePage
extends ContentOutlinePage {
    private AbstractTextEditor editor;
    private TreeViewer viewer;
    private ViewerFilter hideFunctionsFilter;
    private ViewerFilter hideTemplatesFilter;
    private ViewerFilter hideTypesFilter;
    private ViewerFilter groupFilter;
    private ViewerFilter underGroupFilter;
    private static final String ACTION_SORT = "Sort";
    private static final String USE_CATEGORIES = "Categorise";
    private static final String ACTION_TOGGLE_GROUP_MODE = "Toggle Group Mode";
    private static final String ACTION_HIDE_FUNCTIONS = "Hide Functions";
    private static final String ACTION_HIDE_TEMPLATES = "Hide Templates";
    private static final String ACTION_HIDE_TYPES = "Hide Types";

    public OutlinePage(AbstractTextEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.viewer = this.getTreeViewer();
        this.viewer.setContentProvider((IContentProvider)new OutlineContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        OutlineViewSorter comperator = new OutlineViewSorter();
        comperator.setSortByName(store.getBoolean("org.eclipse.titan.designer.outline.sortAlphabetically"));
        comperator.setCategorizing(store.getBoolean("org.eclipse.titan.designer.outline.useCategories"));
        this.viewer.setComparator((ViewerComparator)comperator);
        ViewerFilter filterGroup = this.getGroupFilter();
        ViewerFilter filterUnderGroup = this.getUnderGroupFilter();
        if (store.getBoolean("org.eclipse.titan.designer.outline.useGroups")) {
            this.viewer.removeFilter(filterGroup);
            this.viewer.addFilter(filterUnderGroup);
        } else {
            this.viewer.removeFilter(filterUnderGroup);
            this.viewer.addFilter(filterGroup);
        }
        ViewerFilter filter = this.getHideFunctionsFilter();
        if (store.getBoolean("org.eclipse.titan.designer.outline.hideFunctions")) {
            this.viewer.addFilter(filter);
        } else {
            this.viewer.removeFilter(filter);
        }
        filter = this.getHideTemplatesFilter();
        if (store.getBoolean("org.eclipse.titan.designer.outline.hideTemplates")) {
            this.viewer.addFilter(filter);
        } else {
            this.viewer.removeFilter(filter);
        }
        filter = this.getHideTypesFilter();
        if (store.getBoolean("org.eclipse.titan.designer.outline.hideTypes")) {
            this.viewer.addFilter(filter);
        } else {
            this.viewer.removeFilter(filter);
        }
        this.viewer.setAutoExpandLevel(2);
        this.viewer.setInput((Object)this.getModule());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        IActionBars bars = this.getSite().getActionBars();
        Action sortToggler = new Action(ACTION_SORT){

            public void run() {
                ViewerComparator comperator = OutlinePage.this.viewer.getComparator();
                if (comperator == null) {
                    comperator = new OutlineViewSorter();
                    OutlinePage.this.viewer.setComparator(comperator);
                }
                if (comperator instanceof OutlineViewSorter) {
                    store.setValue("org.eclipse.titan.designer.outline.sortAlphabetically", this.isChecked());
                    ((OutlineViewSorter)comperator).setSortByName(this.isChecked());
                }
                OutlinePage.this.viewer.refresh(false);
            }
        };
        sortToggler.setImageDescriptor(ImageCache.getImageDescriptor("sort_alphabetically.gif"));
        sortToggler.setChecked(store.getBoolean("org.eclipse.titan.designer.outline.sortAlphabetically"));
        bars.getToolBarManager().add((IAction)sortToggler);
        Action categorise = new Action(USE_CATEGORIES){

            public void run() {
                ViewerComparator comperator = OutlinePage.this.viewer.getComparator();
                if (comperator == null) {
                    comperator = new OutlineViewSorter();
                    OutlinePage.this.viewer.setComparator(comperator);
                }
                if (comperator instanceof OutlineViewSorter) {
                    store.setValue("org.eclipse.titan.designer.outline.useCategories", this.isChecked());
                    ((OutlineViewSorter)comperator).setCategorizing(this.isChecked());
                }
                OutlinePage.this.viewer.refresh(false);
            }
        };
        categorise.setImageDescriptor(ImageCache.getImageDescriptor("categorize.gif"));
        categorise.setChecked(store.getBoolean("org.eclipse.titan.designer.outline.useCategories"));
        bars.getToolBarManager().add((IAction)categorise);
        Action toggleGroupMode = new Action(ACTION_TOGGLE_GROUP_MODE){

            public void run() {
                ViewerFilter filterGroup = OutlinePage.this.getGroupFilter();
                ViewerFilter filterUnderGroup = OutlinePage.this.getUnderGroupFilter();
                store.setValue("org.eclipse.titan.designer.outline.useGroups", this.isChecked());
                if (this.isChecked()) {
                    OutlinePage.this.viewer.removeFilter(filterGroup);
                    OutlinePage.this.viewer.addFilter(filterUnderGroup);
                } else {
                    OutlinePage.this.viewer.removeFilter(filterUnderGroup);
                    OutlinePage.this.viewer.addFilter(filterGroup);
                }
                OutlinePage.this.viewer.refresh(false);
            }
        };
        toggleGroupMode.setImageDescriptor(ImageCache.getImageDescriptor("outline_group.gif"));
        toggleGroupMode.setChecked(store.getBoolean("org.eclipse.titan.designer.outline.useGroups"));
        bars.getToolBarManager().add((IAction)toggleGroupMode);
        Action hideFunctions = new Action(ACTION_HIDE_FUNCTIONS){

            public void run() {
                ViewerFilter filter = OutlinePage.this.getHideFunctionsFilter();
                store.setValue("org.eclipse.titan.designer.outline.hideFunctions", this.isChecked());
                if (this.isChecked()) {
                    OutlinePage.this.viewer.addFilter(filter);
                } else {
                    OutlinePage.this.viewer.removeFilter(filter);
                }
                OutlinePage.this.viewer.refresh(false);
            }
        };
        hideFunctions.setImageDescriptor(ImageCache.getImageDescriptor("filter_functions.gif"));
        hideFunctions.setChecked(store.getBoolean("org.eclipse.titan.designer.outline.hideFunctions"));
        bars.getToolBarManager().add((IAction)hideFunctions);
        Action hideTemplates = new Action(ACTION_HIDE_TEMPLATES){

            public void run() {
                ViewerFilter filter = OutlinePage.this.getHideTemplatesFilter();
                store.setValue("org.eclipse.titan.designer.outline.hideTemplates", this.isChecked());
                if (this.isChecked()) {
                    OutlinePage.this.viewer.addFilter(filter);
                } else {
                    OutlinePage.this.viewer.removeFilter(filter);
                }
                OutlinePage.this.viewer.refresh(false);
            }
        };
        hideTemplates.setImageDescriptor(ImageCache.getImageDescriptor("filter_templates.gif"));
        hideTemplates.setChecked(store.getBoolean("org.eclipse.titan.designer.outline.hideTemplates"));
        bars.getToolBarManager().add((IAction)hideTemplates);
        Action hideTypes = new Action(ACTION_HIDE_TYPES){

            public void run() {
                ViewerFilter filter = OutlinePage.this.getHideTypesFilter();
                store.setValue("org.eclipse.titan.designer.outline.hideTypes", this.isChecked());
                if (this.isChecked()) {
                    OutlinePage.this.viewer.addFilter(filter);
                } else {
                    OutlinePage.this.viewer.removeFilter(filter);
                }
                OutlinePage.this.viewer.refresh(false);
            }
        };
        hideTypes.setImageDescriptor(ImageCache.getImageDescriptor("filter_types.gif"));
        hideTypes.setChecked(store.getBoolean("org.eclipse.titan.designer.outline.hideTypes"));
        bars.getToolBarManager().add((IAction)hideTypes);
    }

    private ViewerFilter getGroupFilter() {
        if (this.groupFilter == null) {
            this.groupFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !(element instanceof Group);
                }
            };
        }
        return this.groupFilter;
    }

    private ViewerFilter getUnderGroupFilter() {
        if (this.underGroupFilter == null) {
            this.underGroupFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof Definition && ((Definition)element).getParentGroup() != null && !(parentElement instanceof Group)) {
                        return false;
                    }
                    return !(element instanceof ImportModule) || ((ImportModule)element).getParentGroup() == null || parentElement instanceof Vector;
                }
            };
        }
        return this.underGroupFilter;
    }

    private ViewerFilter getHideFunctionsFilter() {
        if (this.hideFunctionsFilter == null) {
            this.hideFunctionsFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !(element instanceof Def_Function) && !(element instanceof Def_Extfunction);
                }
            };
        }
        return this.hideFunctionsFilter;
    }

    private ViewerFilter getHideTemplatesFilter() {
        if (this.hideTemplatesFilter == null) {
            this.hideTemplatesFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !(element instanceof Def_Template) && !(element instanceof Def_Var_Template);
                }
            };
        }
        return this.hideTemplatesFilter;
    }

    private ViewerFilter getHideTypesFilter() {
        if (this.hideTypesFilter == null) {
            this.hideTypesFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !(element instanceof Def_Type);
                }
            };
        }
        return this.hideTypesFilter;
    }

    public void update() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.setRedraw(false);
            this.getTreeViewer().setInput((Object)this.getModule());
            control.setRedraw(true);
        }
    }

    public void refresh() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setRedraw(false);
        Module module = this.getModule();
        if (this.getTreeViewer().getInput() == module) {
            this.getTreeViewer().refresh();
            this.getTreeViewer().expandToLevel(2);
        } else {
            this.getTreeViewer().setInput((Object)this.getModule());
        }
        control.setRedraw(true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
        Identifier identifier = null;
        if (selectedElement instanceof IOutlineElement) {
            identifier = ((IOutlineElement)selectedElement).getIdentifier();
        }
        if (identifier == null || identifier.getLocation() == null) {
            return;
        }
        Location location = identifier.getLocation();
        this.editor.selectAndReveal(location.getOffset(), location.getEndOffset() - location.getOffset());
    }

    private Module getModule() {
        IFile file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        return sourceParser.containedModule(file);
    }
}

