/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.common.parsers.cfg.CfgDefinitionInformation;
import org.eclipse.titan.common.parsers.cfg.CfgInterval;
import org.eclipse.titan.common.parsers.cfg.CfgLocation;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.ConfigReferenceParser;
import org.eclipse.titan.designer.editors.configeditor.ConfigTextEditor;
import org.eclipse.titan.designer.editors.configeditor.actions.ConfigDeclarationCollectionHelper;
import org.eclipse.titan.designer.editors.configeditor.actions.OpenDeclarationLabelProvider;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public final class OpenDeclaration
extends AbstractHandler
implements IEditorActionDelegate {
    public static final String NOTIDENTIFIABLEFILE = "The file related to the editor could not be identified";
    public static final String NOTDEFINITION = "Selected text does not resolve to a definition";
    public static final String NOTMODULEPARDECLARATION = "Selected text does not resolve to a module parameter declaration";
    public static final String NOTCONSTANTDEFINITION = "Current text selection does not resolve to a constant definition";
    public static final String WRONGSELECTION = "Selected text cannot be mapped to a file name";
    public static final String EDITORNOTFOUND = "The configuration file editor could not be found";
    public static final String FILENOTFOUND = "Could not find included configuration file `{0}'' on include paths";
    private IEditorPart targetEditor = null;
    private ISelection selection = TextSelection.emptySelection();

    public void run(IAction action) {
        int offset;
        if (this.targetEditor instanceof ConfigEditor) {
            this.targetEditor = ((ConfigEditor)this.targetEditor).getEditor();
        }
        if (this.targetEditor == null || !(this.targetEditor instanceof ConfigTextEditor)) {
            return;
        }
        this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        IFile file = (IFile)this.targetEditor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(NOTIDENTIFIABLEFILE);
            return;
        }
        if (!TITANNature.hasTITANNature(file.getProject())) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage("The project containing the selected file does not have the TITAN nature among its natures");
            return;
        }
        if (!this.selection.isEmpty() && this.selection instanceof TextSelection && !"".equals(((TextSelection)this.selection).getText())) {
            IPreferencesService prefs = Platform.getPreferencesService();
            if (prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
                TITANDebugConsole.println("Selected: " + ((TextSelection)this.selection).getText());
            }
            TextSelection textSelection = (TextSelection)this.selection;
            offset = textSelection.getOffset() + textSelection.getLength();
        } else {
            offset = ((ConfigTextEditor)this.targetEditor).getCarretOffset();
        }
        IDocument document = ((ConfigTextEditor)this.targetEditor).getDocument();
        CfgInterval.section_type section = this.getSection(document, offset);
        if (CfgInterval.section_type.UNKNOWN.equals((Object)section)) {
            return;
        }
        if (CfgInterval.section_type.INCLUDE.equals((Object)section)) {
            this.handleIncludes(file, offset, document);
            return;
        }
        if (CfgInterval.section_type.MODULE_PARAMETERS.equals((Object)section) && this.handleModuleParameters(file, offset, document)) {
            return;
        }
        this.handleDefinitions(file, offset, document);
    }

    private void selectAndRevealRegion(IFile file, int offset, int endOffset, boolean select) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        if (desc == null) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(EDITORNOTFOUND);
            return;
        }
        if (!select) {
            return;
        }
        try {
            IWorkbenchPage page = this.targetEditor.getSite().getPage();
            IEditorPart editorPart = page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
            if (editorPart != null) {
                if (editorPart instanceof ConfigEditor) {
                    ((ConfigEditor)editorPart).getEditor().selectAndReveal(offset, endOffset - offset);
                } else if (editorPart instanceof AbstractTextEditor) {
                    ((AbstractTextEditor)editorPart).selectAndReveal(offset, endOffset - offset);
                }
            }
        }
        catch (PartInitException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    public Object openCollectionListDialog(List<?> collected) {
        OpenDeclarationLabelProvider labelProvider = new OpenDeclarationLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(null, (ILabelProvider)labelProvider);
        dialog.setTitle("Open");
        dialog.setMessage("Select the element to open");
        dialog.setElements(collected.toArray());
        if (dialog.open() == 0) {
            return dialog.getFirstResult();
        }
        return null;
    }

    private Assignment openCollectionListDialog(ArrayList<Assignment> assignments) {
        OpenDeclarationLabelProvider labelProvider = new OpenDeclarationLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(null, (ILabelProvider)labelProvider);
        dialog.setTitle("Open");
        dialog.setMessage("Select the element to open");
        dialog.setElements(assignments.toArray());
        if (dialog.open() == 0) {
            return (Assignment)dialog.getFirstResult();
        }
        return null;
    }

    public CfgInterval.section_type getSection(IDocument document, int offset) {
        Interval interval = GlobalIntervalHandler.getInterval(document);
        if (interval == null) {
            return CfgInterval.section_type.UNKNOWN;
        }
        for (Interval subInterval : interval.getSubIntervals()) {
            int startOffset = subInterval.getStartOffset();
            int endOffset = subInterval.getEndOffset();
            if (!(subInterval instanceof CfgInterval) || startOffset > offset || endOffset < offset) continue;
            return ((CfgInterval)subInterval).getSectionType();
        }
        return CfgInterval.section_type.UNKNOWN;
    }

    public void handleIncludes(IFile file, int offset, IDocument document) {
        ConfigReferenceParser refParser = new ConfigReferenceParser(false);
        String include = refParser.findIncludedFileForOpening(offset, document);
        if (include == null || include.length() == 0) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(WRONGSELECTION);
            return;
        }
        IFile fileToOpen = file.getProject().getFile(include);
        if (fileToOpen == null || !fileToOpen.exists()) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(MessageFormat.format(FILENOTFOUND, include));
            return;
        }
        this.selectAndRevealRegion(fileToOpen, -1, -1, false);
    }

    public boolean handleModuleParameters(IFile file, int offset, IDocument document) {
        ConfigReferenceParser refParser = new ConfigReferenceParser(false);
        Reference reference = refParser.findReferenceForOpening(file, offset, document);
        if (refParser.isModuleParameter()) {
            if (reference == null) {
                return false;
            }
            ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
            String exactModuleName = refParser.getExactModuleName();
            ArrayList<Assignment> foundAssignments = new ArrayList<Assignment>();
            if (exactModuleName != null) {
                Module module = projectSourceParser.getModuleByName(exactModuleName);
                if (module != null) {
                    Assignments assignments = module.getAssignments();
                    for (int i = 0; i < assignments.getNofAssignments(); ++i) {
                        Assignment assignment = assignments.getAssignmentByIndex(i);
                        if (!assignment.getIdentifier().getDisplayName().equals(reference.getId().getDisplayName())) continue;
                        foundAssignments.add(assignment);
                    }
                }
            } else {
                for (String moduleName : projectSourceParser.getKnownModuleNames()) {
                    Module module = projectSourceParser.getModuleByName(moduleName);
                    if (module == null) continue;
                    Assignments assignments = module.getAssignments();
                    for (int i = 0; i < assignments.getNofAssignments(); ++i) {
                        Assignment assignment = assignments.getAssignmentByIndex(i);
                        if (!assignment.getIdentifier().getDisplayName().equals(reference.getId().getDisplayName())) continue;
                        foundAssignments.add(assignment);
                    }
                }
            }
            if (foundAssignments.isEmpty()) {
                this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(NOTMODULEPARDECLARATION);
                return false;
            }
            Assignment assignment = null;
            if (foundAssignments.size() == 1) {
                assignment = (Assignment)foundAssignments.get(0);
            } else {
                Assignment result = this.openCollectionListDialog(foundAssignments);
                if (result != null) {
                    assignment = result;
                }
            }
            IPreferencesService prefs = Platform.getPreferencesService();
            if (prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
                for (Assignment tempAssignment : foundAssignments) {
                    Location location = tempAssignment.getLocation();
                    TITANDebugConsole.println("Module parameter: " + location.getFile() + ":" + location.getOffset() + "-" + location.getEndOffset());
                }
            }
            if (assignment != null) {
                Location location = assignment.getLocation();
                this.selectAndRevealRegion((IFile)location.getFile(), location.getOffset(), location.getEndOffset(), true);
            }
            return true;
        }
        return false;
    }

    public void handleDefinitions(IFile file, int offset, IDocument document) {
        ConfigReferenceParser refParser = new ConfigReferenceParser(false);
        refParser.findReferenceForOpening(file, offset, document);
        String definitionName = refParser.getDefinitionName();
        if (definitionName == null) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(NOTDEFINITION);
            return;
        }
        ArrayList<ConfigDeclarationCollectionHelper> collected = new ArrayList<ConfigDeclarationCollectionHelper>();
        Map<String, CfgDefinitionInformation> definitions = GlobalParser.getConfigSourceParser(file.getProject()).getAllDefinitions();
        CfgDefinitionInformation definition = definitions.get(definitionName);
        if (definition != null) {
            List locations = definition.getLocations();
            for (CfgLocation location : locations) {
                collected.add(new ConfigDeclarationCollectionHelper(definitionName, location));
            }
        } else {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(NOTCONSTANTDEFINITION);
            return;
        }
        if (collected.isEmpty()) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(NOTCONSTANTDEFINITION);
            return;
        }
        ConfigDeclarationCollectionHelper declaration = null;
        if (collected.size() == 1) {
            declaration = (ConfigDeclarationCollectionHelper)collected.get(0);
        } else {
            Object result = this.openCollectionListDialog((List<?>)collected);
            if (result != null) {
                declaration = (ConfigDeclarationCollectionHelper)result;
            }
        }
        if (declaration != null) {
            this.selectAndRevealRegion(declaration.location.getFile(), declaration.location.getOffset(), declaration.location.getEndOffset(), true);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        int offset;
        this.targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (this.targetEditor instanceof ConfigEditor) {
            this.targetEditor = ((ConfigEditor)this.targetEditor).getEditor();
        }
        if (this.targetEditor == null || !(this.targetEditor instanceof ConfigTextEditor)) {
            return null;
        }
        this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        IFile file = (IFile)this.targetEditor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(NOTIDENTIFIABLEFILE);
            return null;
        }
        if (!TITANNature.hasTITANNature(file.getProject())) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage("The project containing the selected file does not have the TITAN nature among its natures");
            return null;
        }
        if (!this.selection.isEmpty() && this.selection instanceof TextSelection && !"".equals(((TextSelection)this.selection).getText())) {
            IPreferencesService prefs = Platform.getPreferencesService();
            if (prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
                TITANDebugConsole.println("Selected: " + ((TextSelection)this.selection).getText());
            }
            TextSelection textSelection = (TextSelection)this.selection;
            offset = textSelection.getOffset() + textSelection.getLength();
        } else {
            offset = ((ConfigTextEditor)this.targetEditor).getCarretOffset();
        }
        IDocument document = ((ConfigTextEditor)this.targetEditor).getDocument();
        CfgInterval.section_type section = this.getSection(document, offset);
        if (CfgInterval.section_type.UNKNOWN.equals((Object)section)) {
            if (this.handleModuleParameters(file, offset, document)) {
                return null;
            }
            return null;
        }
        if (CfgInterval.section_type.INCLUDE.equals((Object)section)) {
            this.handleIncludes(file, offset, document);
            return null;
        }
        if (CfgInterval.section_type.MODULE_PARAMETERS.equals((Object)section) && this.handleModuleParameters(file, offset, document)) {
            return null;
        }
        this.handleDefinitions(file, offset, document);
        return null;
    }
}

