/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.FileBuildPropertyData;
import org.eclipse.titan.designer.properties.data.FolderBuildPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectBuildPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectRemoteBuildPropertyData;

public final class TITANNature
implements IProjectNature {
    public static final String NATURE_ID = "org.eclipse.titan.designer.core.TITANNature";
    public static final String LOG_NATURE_ID = "org.eclipse.titan.log.viewer.TitanLogProject";
    public static final String NO_TITAN_NATURE_FOUND = "The selected project does not have the TITAN nature among its natures";
    public static final String NO_TITAN_FILE_NATURE_FOUND = "The project containing the selected file does not have the TITAN nature among its natures";
    private IProject project;

    public void configure() throws CoreException {
        TITANNature.addTITANBuilderToProject(this.project);
    }

    public void deconfigure() throws CoreException {
        TITANNature.removeTITANBuilderFromProject(this.project);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static void addTITANNatureToProject(IProjectDescription description) {
        ArrayList<String> newIds = new ArrayList<String>();
        newIds.addAll(Arrays.asList(description.getNatureIds()));
        int index = newIds.indexOf(NATURE_ID);
        if (index == -1) {
            newIds.add(NATURE_ID);
        }
        if ((index = newIds.indexOf(LOG_NATURE_ID)) == -1) {
            newIds.add(LOG_NATURE_ID);
        }
        description.setNatureIds(newIds.toArray(new String[newIds.size()]));
    }

    public static void removeTITANNature(IProjectDescription description) {
        ArrayList<String> natureIds = new ArrayList<String>();
        natureIds.addAll(Arrays.asList(description.getNatureIds()));
        int index = natureIds.indexOf(NATURE_ID);
        if (index != -1) {
            natureIds.remove(index);
        }
        if ((index = natureIds.indexOf(LOG_NATURE_ID)) != -1) {
            natureIds.remove(index);
        }
        description.setNatureIds(natureIds.toArray(new String[natureIds.size()]));
    }

    public static boolean hasTITANNature(IProject project) {
        try {
            return project != null && project.isAccessible() && project.hasNature(NATURE_ID);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
    }

    private static int getJavaCommandIndex(ICommand[] buildSpec) {
        for (int i = 0; i < buildSpec.length; ++i) {
            if (!"org.eclipse.titan.designer.core.TITANBuilder".equals(buildSpec[i].getBuilderName())) continue;
            return i;
        }
        return -1;
    }

    public static void addTITANBuilderToProject(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        int javaCommandIndex = TITANNature.getJavaCommandIndex(description.getBuildSpec());
        if (javaCommandIndex == -1) {
            ICommand newCommand = description.newCommand();
            newCommand.setBuilderName("org.eclipse.titan.designer.core.TITANBuilder");
            ICommand[] oldBuildSpec = description.getBuildSpec();
            ICommand[] newCommands = new ICommand[oldBuildSpec.length + 1];
            System.arraycopy(oldBuildSpec, 0, newCommands, 1, oldBuildSpec.length);
            newCommands[0] = newCommand;
            description.setBuildSpec(newCommands);
            project.setDescription(description, null);
        }
    }

    public static void removeTITANBuilderFromProject(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        int javaCommandIndex = TITANNature.getJavaCommandIndex(description.getBuildSpec());
        if (javaCommandIndex == -1) {
            return;
        }
        ICommand[] oldBuildSpec = description.getBuildSpec();
        ICommand[] newCommands = new ICommand[oldBuildSpec.length - 1];
        System.arraycopy(oldBuildSpec, 0, newCommands, 0, javaCommandIndex);
        System.arraycopy(oldBuildSpec, javaCommandIndex + 1, newCommands, javaCommandIndex, oldBuildSpec.length - javaCommandIndex - 1);
        description.setBuildSpec(newCommands);
        project.setDescription(description, null);
        try {
            project.accept((IResourceVisitor)new NatureRemovingVisitor());
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    private static class NatureRemovingVisitor
    implements IResourceVisitor {
        private NatureRemovingVisitor() {
        }

        public boolean visit(IResource resource) {
            switch (resource.getType()) {
                case 4: {
                    ProjectBuildPropertyData.removeTITANAttributes((IProject)resource);
                    ProjectRemoteBuildPropertyData.removeTITANAttributes((IProject)resource);
                    break;
                }
                case 2: {
                    FolderBuildPropertyData.removeTITANAttributes((IFolder)resource);
                    break;
                }
                case 1: {
                    FileBuildPropertyData.removeTITANAttributes((IFile)resource);
                    break;
                }
            }
            return true;
        }
    }
}

