/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class RNDWithValueExpression
extends Expression_Value {
    private static final String OPERANDERROR = "The operand of the `rnd' operation should be a float value";
    private static final String OPERANDERROR2 = "{0} can not be used as operand of the `rnd'' operation";
    private static final String OPERATIONNAME = "rnd()";
    private final Value value;

    public RNDWithValueExpression(Value value) {
        this.value = value;
        if (value != null) {
            value.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.RNDWITHVALUE_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("rnd(").append(this.value.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(".<operand>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_REAL;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value == null) {
            return;
        }
        this.value.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.value.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_REAL: {
                Real_Value real;
                IValue last = this.value.getValueRefdLast(timestamp, expectedValue, referenceChain);
                if (last.isUnfoldable(timestamp) || !(real = (Real_Value)last).isSpecialFloat()) break;
                this.value.getLocation().reportSemanticError(MessageFormat.format(OPERANDERROR2, real.createStringRepresentation()));
                this.setIsErroneous(true);
                break;
            }
            case TYPE_UNDEFINED: {
                this.setIsErroneous(true);
                return;
            }
            default: {
                if (!this.isErroneous) {
                    this.location.reportSemanticError(OPERANDERROR);
                    this.setIsErroneous(true);
                }
                return;
            }
        }
        this.checkExpressionDynamicPart(expectedValue, OPERATIONNAME, true, true, false);
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.value != null) {
            referenceChain.markState();
            this.value.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value == null) {
            return;
        }
        this.value.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.value == null || this.value.accept(v);
    }
}

