/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.TTCN3.values.CharstringExtractor;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalChar;

public final class UniversalCharstring
implements Comparable<UniversalCharstring> {
    private List<UniversalChar> value;
    private boolean mErrorneous = false;
    private String mErrorMessage;

    public UniversalCharstring() {
        this.value = new ArrayList<UniversalChar>();
    }

    public UniversalCharstring(UniversalChar character) {
        this.value = new ArrayList<UniversalChar>(1);
        this.value.add(character);
    }

    public UniversalCharstring(String string) {
        String extracted;
        CharstringExtractor cs = new CharstringExtractor(string);
        if (cs.isErrorneous()) {
            this.mErrorneous = true;
            this.mErrorMessage = cs.getErrorMessage();
        }
        if ((extracted = cs.getExtractedString()) != null) {
            this.value = new ArrayList<UniversalChar>(extracted.length());
            for (int i = 0; i < extracted.length(); ++i) {
                this.value.add(new UniversalChar(0, 0, 0, extracted.charAt(i)));
            }
        }
    }

    public boolean isErrorneous() {
        return this.mErrorneous;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public UniversalCharstring(UniversalCharstring other) {
        this.value = new ArrayList<UniversalChar>(other.value.size());
        for (int i = 0; i < other.value.size(); ++i) {
            this.value.add(other.value.get(i));
        }
    }

    private UniversalCharstring(List<UniversalChar> value) {
        this.value = value;
    }

    public int length() {
        return this.value.size();
    }

    public UniversalChar get(int index) {
        return this.value.get(index);
    }

    public String getString() {
        StringBuilder builder = new StringBuilder(this.value.size());
        for (int i = 0; i < this.value.size(); ++i) {
            builder.append(this.value.get(i).cell());
        }
        return builder.toString();
    }

    public String getStringRepresentation() {
        StringBuilder builder = new StringBuilder(this.value.size());
        for (int i = 0; i < this.value.size(); ++i) {
            UniversalChar tempChar = this.value.get(i);
            if (tempChar.group() == 0 && tempChar.plane() == 0 && tempChar.row() == 0) {
                builder.append((char)tempChar.cell());
                continue;
            }
            builder.append("char(").append(tempChar.group()).append(',').append(tempChar.plane()).append(',').append(tempChar.row()).append(',').append(tempChar.cell()).append(')');
        }
        return builder.toString();
    }

    public UniversalCharstring substring(int beginIndex) {
        return this.substring(beginIndex, this.value.size());
    }

    public UniversalCharstring substring(int beginIndex, int endIndex) {
        ArrayList<UniversalChar> newList = new ArrayList<UniversalChar>(this.value.subList(beginIndex, endIndex));
        return new UniversalCharstring(newList);
    }

    public UniversalCharstring append(String other) {
        for (int i = 0; i < other.length(); ++i) {
            this.value.add(new UniversalChar(0, 0, 0, other.charAt(i)));
        }
        return this;
    }

    public UniversalCharstring append(UniversalCharstring other) {
        for (int i = 0; i < other.value.size(); ++i) {
            this.value.add(other.value.get(i));
        }
        return this;
    }

    public static boolean isCharstring(String string) {
        if (string == null) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public int compareWith(UniversalCharstring other) {
        if (this == other) {
            return 0;
        }
        int i = 0;
        while (true) {
            if (i == this.value.size()) {
                if (i == other.value.size()) {
                    return 0;
                }
                return -1;
            }
            if (i == other.value.size()) {
                return 1;
            }
            UniversalChar actual = this.value.get(i);
            UniversalChar otherActual = other.value.get(i);
            if (actual.group() > otherActual.group()) {
                return 1;
            }
            if (actual.group() < otherActual.group()) {
                return -1;
            }
            if (actual.plane() > otherActual.plane()) {
                return 1;
            }
            if (actual.plane() < otherActual.plane()) {
                return -1;
            }
            if (actual.row() > otherActual.row()) {
                return 1;
            }
            if (actual.row() < otherActual.row()) {
                return -1;
            }
            if (actual.cell() > otherActual.cell()) {
                return 1;
            }
            if (actual.cell() < otherActual.cell()) {
                return -1;
            }
            ++i;
        }
    }

    @Override
    public int compareTo(UniversalCharstring other) {
        return this.compareWith(other);
    }

    public boolean checkEquality(UniversalCharstring other) {
        if (this == other) {
            return true;
        }
        if (this.value.size() != other.value.size()) {
            return false;
        }
        for (int i = 0; i < this.value.size(); ++i) {
            if (this.value.get(i).checkEquality(other.value.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean checkEquality(String other) {
        if (this.value.size() != other.length()) {
            return false;
        }
        for (int i = 0; i < this.value.size(); ++i) {
            if (this.value.get(i).checkEquality(other.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        int size = this.value.size();
        for (int i = 0; i < size; ++i) {
            UniversalChar temp = this.value.get(i);
            h = 31 * h + temp.group();
            h = 31 * h + temp.plane();
            h = 31 * h + temp.row();
            h = 31 * h + temp.cell();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UniversalCharstring) {
            return this.checkEquality((UniversalCharstring)obj);
        }
        return false;
    }
}

