/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.LimitType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.RangeListConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SizeLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubtypeConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.TernaryBool;

public final class StringSizeAndValueListConstraint
extends SubtypeConstraint {
    private final Type type;
    private RangeListConstraint sizeConstraint;
    private Set<String> hasValues;
    private Set<String> notValues;

    private void canonicalize(Set<String> values, Set<String> otherValues, boolean ifValues) {
        HashMap<Integer, Integer> valuesLengths = new HashMap<Integer, Integer>();
        for (String string : values) {
            int valueSize = string.length() / this.type.elemSize();
            if (valuesLengths.containsKey(valueSize)) {
                valuesLengths.put(valueSize, (Integer)valuesLengths.get(valueSize) + 1);
                continue;
            }
            valuesLengths.put(valueSize, 1);
        }
        for (Map.Entry entry : valuesLengths.entrySet()) {
            Iterator<String> i;
            int size = (Integer)entry.getKey();
            int count = (Integer)entry.getValue();
            int allValuesCount = Integer.MAX_VALUE;
            if (this.type.bitCount() * size < 32) {
                allValuesCount = 1 << this.type.bitCount() * size;
            }
            if (count == allValuesCount) {
                i = values.iterator();
                while (i.hasNext()) {
                    if (i.next().length() / this.type.elemSize() != size) continue;
                    i.remove();
                }
                if (ifValues) {
                    this.sizeConstraint = this.sizeConstraint.union(new RangeListConstraint(new SizeLimit(size)));
                    continue;
                }
                this.sizeConstraint = (RangeListConstraint)this.sizeConstraint.except(new RangeListConstraint(new SizeLimit(size)));
                continue;
            }
            if ((ifValues || count < allValuesCount / 2) && (!ifValues || count <= allValuesCount / 2)) continue;
            for (int actualValue = 0; actualValue < allValuesCount; ++actualValue) {
                StringBuilder sb = new StringBuilder();
                for (int elemIndex = 0; elemIndex < size; ++elemIndex) {
                    int ei = actualValue >> elemIndex * this.type.bitCount() & (1 << this.type.bitCount()) - 1;
                    if (this.type == Type.BITSTRING) {
                        sb.append((char)(48 + ei));
                        continue;
                    }
                    if (this.type == Type.HEXSTRING) {
                        sb.append(ei < 10 ? (char)(48 + ei) : (char)(65 + (ei - 10)));
                        continue;
                    }
                    if (this.type != Type.OCTETSTRING) continue;
                    int c = ei & 0xF;
                    sb.append(c < 10 ? (char)(48 + c) : (char)(65 + (c - 10)));
                    c = ei >> this.type.bitCount() / this.type.elemSize() & 0xF;
                    sb.append(c < 10 ? (char)(48 + c) : (char)(65 + (c - 10)));
                }
                String str = sb.toString();
                if (values.contains(str)) continue;
                otherValues.add(str);
            }
            i = values.iterator();
            while (i.hasNext()) {
                if (i.next().length() / this.type.elemSize() != size) continue;
                i.remove();
            }
            if (ifValues) {
                this.sizeConstraint = this.sizeConstraint.union(new RangeListConstraint(new SizeLimit(size)));
                continue;
            }
            this.sizeConstraint = (RangeListConstraint)this.sizeConstraint.except(new RangeListConstraint(new SizeLimit(size)));
        }
    }

    private void canonicalize() {
        this.canonicalize(this.hasValues, this.notValues, true);
        this.canonicalize(this.notValues, this.hasValues, false);
    }

    public StringSizeAndValueListConstraint(Type type) {
        this.type = type;
        this.sizeConstraint = new RangeListConstraint(LimitType.Type.SIZE);
        this.hasValues = new TreeSet<String>();
        this.notValues = new TreeSet<String>();
    }

    public StringSizeAndValueListConstraint(Type type, String str) {
        this(type);
        this.hasValues.add(str);
    }

    public StringSizeAndValueListConstraint(Type type, LimitType sl) {
        this.type = type;
        this.sizeConstraint = new RangeListConstraint(sl);
        this.hasValues = new TreeSet<String>();
        this.notValues = new TreeSet<String>();
    }

    public StringSizeAndValueListConstraint(Type type, LimitType slBegin, LimitType slEnd) {
        this.type = type;
        this.sizeConstraint = new RangeListConstraint(slBegin, slEnd);
        this.hasValues = new TreeSet<String>();
        this.notValues = new TreeSet<String>();
    }

    @Override
    public StringSizeAndValueListConstraint complement() {
        StringSizeAndValueListConstraint returnValue = new StringSizeAndValueListConstraint(this.type);
        returnValue.sizeConstraint = this.sizeConstraint.complement();
        returnValue.notValues = new TreeSet<String>(this.hasValues);
        returnValue.hasValues = new TreeSet<String>(this.notValues);
        returnValue.canonicalize();
        return returnValue;
    }

    private StringSizeAndValueListConstraint setOperation(SubtypeConstraint other, boolean isUnion) {
        String str2;
        StringSizeAndValueListConstraint o = (StringSizeAndValueListConstraint)other;
        StringSizeAndValueListConstraint returnValue = new StringSizeAndValueListConstraint(this.type);
        returnValue.sizeConstraint = this.sizeConstraint.setOperation(o.sizeConstraint, isUnion);
        if (isUnion) {
            returnValue.hasValues.addAll(this.hasValues);
            returnValue.hasValues.addAll(o.hasValues);
            returnValue.notValues.addAll(this.notValues);
            returnValue.notValues.retainAll(o.notValues);
            for (String str2 : o.notValues) {
                if (this.sizeConstraint.isElement(new SizeLimit(str2.length() / this.type.elemSize()))) continue;
                returnValue.notValues.add(str2);
            }
            for (String str2 : this.notValues) {
                if (o.sizeConstraint.isElement(new SizeLimit(str2.length() / this.type.elemSize()))) continue;
                returnValue.notValues.add(str2);
            }
        } else {
            returnValue.hasValues.addAll(this.hasValues);
            returnValue.hasValues.retainAll(o.hasValues);
            for (String str2 : this.hasValues) {
                if (!o.sizeConstraint.isElement(new SizeLimit(str2.length() / this.type.elemSize())) || o.notValues.contains(str2)) continue;
                returnValue.hasValues.add(str2);
            }
            for (String str2 : o.hasValues) {
                if (!this.sizeConstraint.isElement(new SizeLimit(str2.length() / this.type.elemSize())) || this.notValues.contains(str2)) continue;
                returnValue.hasValues.add(str2);
            }
            returnValue.notValues.addAll(this.notValues);
            returnValue.notValues.addAll(o.notValues);
        }
        Iterator<String> i = returnValue.notValues.iterator();
        while (i.hasNext()) {
            str2 = i.next();
            if (!returnValue.hasValues.contains(str2)) continue;
            returnValue.hasValues.remove(str2);
            i.remove();
        }
        i = returnValue.hasValues.iterator();
        while (i.hasNext()) {
            str2 = i.next();
            if (!returnValue.sizeConstraint.isElement(new SizeLimit(str2.length() / this.type.elemSize()))) continue;
            i.remove();
        }
        i = returnValue.notValues.iterator();
        while (i.hasNext()) {
            str2 = i.next();
            if (returnValue.sizeConstraint.isElement(new SizeLimit(str2.length() / this.type.elemSize()))) continue;
            i.remove();
        }
        returnValue.canonicalize();
        return returnValue;
    }

    @Override
    public StringSizeAndValueListConstraint intersection(SubtypeConstraint other) {
        return this.setOperation(other, false);
    }

    @Override
    public boolean isElement(Object o) {
        String s = (String)o;
        return this.sizeConstraint.isElement(new SizeLimit(s.length() / this.type.elemSize())) && !this.notValues.contains(s) || this.hasValues.contains(s);
    }

    @Override
    public TernaryBool isEmpty() {
        return this.sizeConstraint.isEmpty().and(TernaryBool.fromBool(this.hasValues.isEmpty()));
    }

    @Override
    public TernaryBool isEqual(SubtypeConstraint other) {
        StringSizeAndValueListConstraint o = (StringSizeAndValueListConstraint)other;
        return this.sizeConstraint.isEqual(o.sizeConstraint).and(TernaryBool.fromBool(this.hasValues.equals(o.hasValues)).and(TernaryBool.fromBool(this.notValues.equals(o.notValues))));
    }

    @Override
    public TernaryBool isFull() {
        return this.sizeConstraint.isFull().and(TernaryBool.fromBool(this.notValues.isEmpty()));
    }

    private void valuesToString(StringBuilder sb, Set<String> values) {
        sb.append('(');
        boolean needComma = false;
        for (String s : values) {
            if (needComma) {
                sb.append(", ");
            }
            sb.append('\'');
            sb.append(s);
            sb.append('\'');
            sb.append(this.type.suffix());
            needComma = true;
        }
        sb.append(')');
    }

    @Override
    public void toString(StringBuilder sb) {
        if (!this.hasValues.isEmpty()) {
            this.valuesToString(sb, this.hasValues);
        }
        if (this.sizeConstraint.isEmpty() != TernaryBool.TTRUE) {
            if (!this.hasValues.isEmpty()) {
                sb.append(" union ");
            }
            sb.append("length");
            this.sizeConstraint.toString(sb);
        }
        if (!this.notValues.isEmpty()) {
            sb.append(" except ");
            this.valuesToString(sb, this.notValues);
        }
    }

    @Override
    public SubtypeConstraint union(SubtypeConstraint other) {
        return this.setOperation(other, true);
    }

    public static enum Type {
        BITSTRING(1, 1, 'B'),
        HEXSTRING(4, 1, 'H'),
        OCTETSTRING(8, 2, 'O');

        private final int bitcount;
        private final int elemsize;
        private final char suffix;

        private Type(int bitcount, int elemsize, char suffix) {
            this.bitcount = bitcount;
            this.elemsize = elemsize;
            this.suffix = suffix;
        }

        public int bitCount() {
            return this.bitcount;
        }

        public int elemSize() {
            return this.elemsize;
        }

        public char suffix() {
            return this.suffix;
        }
    }
}

