/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceableElement;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ITypeWithComponents;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifier;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.CompFieldMap;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public abstract class TTCN3_Set_Seq_Choice_BaseType
extends Type
implements ITypeWithComponents,
IReferenceableElement {
    public static final String NONEXISTENTFIELDREFERENCE = "Reference to non-existent field `{0}'' in type `{1}''";
    protected CompFieldMap compFieldMap;
    private boolean componentInternal;

    public TTCN3_Set_Seq_Choice_BaseType(CompFieldMap compFieldMap) {
        this.compFieldMap = compFieldMap;
        this.componentInternal = false;
        compFieldMap.setMyType(this);
        compFieldMap.setFullNameParent(this);
    }

    @Override
    public final void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.compFieldMap.setMyScope(scope);
    }

    public final int getNofComponents() {
        if (this.compFieldMap == null) {
            return 0;
        }
        return this.compFieldMap.fields.size();
    }

    public final CompField getComponentByIndex(int index) {
        return this.compFieldMap.fields.get(index);
    }

    public final boolean hasComponentWithName(String name) {
        if (this.compFieldMap.componentFieldMap == null) {
            return false;
        }
        return this.compFieldMap.componentFieldMap.containsKey(name);
    }

    public final CompField getComponentByName(String name) {
        if (this.compFieldMap.componentFieldMap == null) {
            return null;
        }
        return this.compFieldMap.componentFieldMap.get(name);
    }

    public final Identifier getComponentIdentifierByIndex(int index) {
        return this.compFieldMap.fields.get(index).getIdentifier();
    }

    @Override
    public final IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.compFieldMap.getCompWithName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return null;
                }
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return null;
                }
                if (interruptIfOptional && compField.isOptional()) {
                    return null;
                }
                Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
                return fieldType.getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean getSubrefsAsArray(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, List<Integer> subrefsArray, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return false;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.compFieldMap.getCompWithName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return false;
                }
                int fieldIndex = this.compFieldMap.fields.indexOf(compField);
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return false;
                }
                subrefsArray.add(fieldIndex);
                typeArray.add(this);
                return fieldType.getSubrefsAsArray(timestamp, reference, actualSubReference + 1, subrefsArray, typeArray);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return false;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return false;
    }

    @Override
    public boolean getFieldTypesAsArray(Reference reference, int actualSubReference, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                return false;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                if (this.compFieldMap == null) {
                    return false;
                }
                CompField compField = this.compFieldMap.getCompWithName(id);
                if (compField == null) {
                    return false;
                }
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return false;
                }
                typeArray.add(this);
                return fieldType.getFieldTypesAsArray(reference, actualSubReference + 1, typeArray);
            }
            case parameterisedSubReference: {
                return false;
            }
        }
        return false;
    }

    @Override
    public final boolean isComponentInternal(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.componentInternal;
    }

    @Override
    public void parseAttributes(CompilationTimeStamp timestamp) {
        this.checkDoneAttribute(timestamp);
        if (!this.hasVariantAttributes(timestamp)) {
            return;
        }
        MultipleWithAttributes selfAttributes = this.withAttributesPath.getAttributes();
        if (selfAttributes == null) {
            return;
        }
        MultipleWithAttributes newSelfAttributes = new MultipleWithAttributes();
        for (int i = 0; i < selfAttributes.getNofElements(); ++i) {
            SingleWithAttribute temp = selfAttributes.getAttribute(i);
            if (!SingleWithAttribute.Attribute_Type.Encode_Attribute.equals((Object)temp.getAttributeType())) continue;
            SingleWithAttribute newAttribute = new SingleWithAttribute(temp.getAttributeType(), temp.hasOverride(), null, temp.getAttributeSpecification());
            newSelfAttributes.addAttribute(newAttribute);
        }
        WithAttributesPath encodeAttributePath = null;
        if (newSelfAttributes.getNofElements() > 0) {
            encodeAttributePath = new WithAttributesPath();
            encodeAttributePath.setWithAttributes(newSelfAttributes);
            encodeAttributePath.setAttributeParent(this.withAttributesPath.getAttributeParent());
        }
        int size = this.getNofComponents();
        for (int i = 0; i < size; ++i) {
            CompField componentField = this.getComponentByIndex(i);
            Type componentType = componentField.getType();
            componentType.clearWithAttributes();
            if (encodeAttributePath == null) {
                componentType.setAttributeParentPath(this.withAttributesPath.getAttributeParent());
                continue;
            }
            componentType.setAttributeParentPath(encodeAttributePath);
        }
        for (int j = 0; j < selfAttributes.getNofElements(); ++j) {
            SingleWithAttribute tempSingle = selfAttributes.getAttribute(j);
            Qualifiers tempQualifiers = tempSingle.getQualifiers();
            if (tempQualifiers == null || tempQualifiers.getNofQualifiers() == 0) continue;
            int kmax = tempQualifiers.getNofQualifiers();
            for (int k = 0; k < kmax; ++k) {
                Qualifier tempQualifier = tempQualifiers.getQualifierByIndex(k);
                if (tempQualifier.getNofSubReferences() == 0) continue;
                ISubReference tempSubReference = tempQualifier.getSubReferenceByIndex(0);
                boolean componentFound = false;
                int size2 = this.getNofComponents();
                for (int i = 0; i < size2; ++i) {
                    CompField componentField = this.getComponentByIndex(i);
                    Identifier componentId = componentField.getIdentifier();
                    if (tempSubReference.getReferenceType() != ISubReference.Subreference_type.fieldSubReference || !tempSubReference.getId().equals(componentId)) continue;
                    Qualifiers calculatedQualifiers = new Qualifiers();
                    calculatedQualifiers.addQualifier(tempQualifier.getQualifierWithoutFirstSubRef());
                    SingleWithAttribute tempSingle2 = new SingleWithAttribute(tempSingle.getAttributeType(), tempSingle.hasOverride(), calculatedQualifiers, tempSingle.getAttributeSpecification());
                    tempSingle2.setLocation(new Location(tempSingle.getLocation()));
                    Type componentType = componentField.getType();
                    MultipleWithAttributes componentAttributes = componentType.getAttributePath().getAttributes();
                    if (componentAttributes == null) {
                        componentAttributes = new MultipleWithAttributes();
                        componentAttributes.addAttribute(tempSingle2);
                        componentType.setWithAttributes(componentAttributes);
                    } else {
                        componentAttributes.addAttribute(tempSingle2);
                    }
                    componentFound = true;
                }
                if (componentFound) continue;
                if (tempSubReference.getReferenceType() == ISubReference.Subreference_type.arraySubReference) {
                    tempQualifier.getLocation().reportSemanticError("Invalid field qualifier [-]");
                    continue;
                }
                tempQualifier.getLocation().reportSemanticError(MessageFormat.format("Invalid field qualifier {0}", tempSubReference.getId().getDisplayName()));
            }
        }
    }

    @Override
    public final void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.componentInternal = false;
        this.isErroneous = false;
        this.parseAttributes(timestamp);
        this.compFieldMap.check(timestamp);
        int size = this.getNofComponents();
        for (int i = 0; i < size; ++i) {
            Type type = this.getComponentByIndex(i).getType();
            if (type == null || !type.isComponentInternal(timestamp)) continue;
            this.componentInternal = true;
            break;
        }
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
        this.checkSubtypeRestrictions(timestamp);
    }

    @Override
    public final void checkComponentInternal(CompilationTimeStamp timestamp, Set<IType> typeSet, String operation) {
        if (typeSet.contains(this)) {
            return;
        }
        typeSet.add(this);
        int size = this.getNofComponents();
        for (int i = 0; i < size; ++i) {
            Type type = this.getComponentByIndex(i).getType();
            if (type == null || !type.isComponentInternal(timestamp)) continue;
            type.checkComponentInternal(timestamp, typeSet, operation);
        }
        typeSet.remove(this);
    }

    @Override
    public final Object[] getOutlineChildren() {
        return this.compFieldMap.getOutlineChildren();
    }

    @Override
    public final void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.compFieldMap.getCompWithName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addProposal(propCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.compFieldMap.getComponentsWithPrefix(subreference.getId().getName());
                for (CompField compField : compFields) {
                    String proposalKind = compField.getType().getProposalDescription(new StringBuilder()).toString();
                    propCollector.addProposal(compField.getIdentifier(), " - " + proposalKind, ImageCache.getImage(this.getOutlineIcon()), proposalKind);
                    IType type = compField.getType();
                    if (type == null || !compField.getIdentifier().equals(subreference.getId())) continue;
                    type = type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                    type.addProposal(propCollector, i + 1);
                }
            }
        }
    }

    @Override
    public final void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.compFieldMap.getCompWithName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addDeclaration(declarationCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.compFieldMap.getComponentsWithPrefix(subreference.getId().getName());
                for (CompField compField : compFields) {
                    declarationCollector.addDeclaration(compField.getIdentifier().getDisplayName(), compField.getIdentifier().getLocation(), this);
                }
            }
        }
    }

    @Override
    public final void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean handled = false;
            if (this.compFieldMap != null && reparser.envelopsDamage(this.compFieldMap.getLocation())) {
                try {
                    this.compFieldMap.updateSyntax(reparser, true);
                }
                catch (ReParseException e) {
                    e.decreaseDepth();
                    throw e;
                }
                reparser.updateLocation(this.compFieldMap.getLocation());
                handled = true;
            }
            if (this.subType != null) {
                this.subType.updateSyntax(reparser, false);
                handled = true;
            }
            if (handled) {
                return;
            }
            throw new ReParseException();
        }
        reparser.updateLocation(this.compFieldMap.getLocation());
        this.compFieldMap.updateSyntax(reparser, false);
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void getEnclosingField(int offset, ReferenceFinder rf) {
        this.compFieldMap.getEnclosingField(offset, rf);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.compFieldMap != null) {
            this.compFieldMap.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.compFieldMap == null || this.compFieldMap.accept(v);
    }

    @Override
    public Identifier getComponentIdentifierByName(Identifier identifier) {
        CompField cf = this.getComponentByName(identifier.getName());
        return cf == null ? null : cf.getIdentifier();
    }

    @Override
    public Declaration resolveReference(Reference reference, int subRefIdx, ISubReference lastSubreference) {
        int localIndex;
        List<ISubReference> subreferences = reference.getSubreferences();
        for (localIndex = subRefIdx; localIndex < subreferences.size() && subreferences.get(localIndex) instanceof ArraySubReference; ++localIndex) {
        }
        if (localIndex == subreferences.size()) {
            return null;
        }
        CompField compField = this.getComponentByName(subreferences.get(localIndex).getId().getName());
        if (compField == null) {
            return null;
        }
        IType compFieldType = compField.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (subreferences.get(localIndex) == lastSubreference) {
            return Declaration.createInstance(this.getDefiningAssignment(), compField.getIdentifier());
        }
        if (compFieldType instanceof IReferenceableElement) {
            Declaration decl = ((IReferenceableElement)((Object)compFieldType)).resolveReference(reference, localIndex + 1, lastSubreference);
            return decl != null ? decl : Declaration.createInstance(this.getDefiningAssignment(), compField.getIdentifier());
        }
        return null;
    }
}

