/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.statements.Receive_Port_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Check_Receive_Port_Statement
extends Statement {
    private static final String FULLNAMEPART1 = ".portreference";
    private static final String FULLNAMEPART2 = ".receiveparameter";
    private static final String FULLNAMEPART3 = ".from";
    private static final String FULLNAMEPART4 = ".redirectvalue";
    private static final String FULLNAMEPART5 = ".redirectsender";
    private static final String STATEMENT_NAME = "check-receive";
    private final Reference portReference;
    private final TemplateInstance receiveParameter;
    private final TemplateInstance fromClause;
    private final Reference redirectValue;
    private final Reference redirectSender;

    public Check_Receive_Port_Statement(Reference portReference, TemplateInstance receiveParameter, TemplateInstance fromClause, Reference redirectValue, Reference redirectSender) {
        this.portReference = portReference;
        this.receiveParameter = receiveParameter;
        this.fromClause = fromClause;
        this.redirectValue = redirectValue;
        this.redirectSender = redirectSender;
        if (portReference != null) {
            portReference.setFullNameParent(this);
        }
        if (receiveParameter != null) {
            receiveParameter.setFullNameParent(this);
        }
        if (fromClause != null) {
            fromClause.setFullNameParent(this);
        }
        if (redirectValue != null) {
            redirectValue.setFullNameParent(this);
        }
        if (redirectSender != null) {
            redirectSender.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_CHECK_RECEIVE;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.receiveParameter == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.fromClause == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.redirectValue == child) {
            return builder.append(FULLNAMEPART4);
        }
        if (this.redirectSender == child) {
            return builder.append(FULLNAMEPART5);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.portReference != null) {
            this.portReference.setMyScope(scope);
        }
        if (this.receiveParameter != null) {
            this.receiveParameter.setMyScope(scope);
        }
        if (this.fromClause != null) {
            this.fromClause.setMyScope(scope);
        }
        if (this.redirectValue != null) {
            this.redirectValue.setMyScope(scope);
        }
        if (this.redirectSender != null) {
            this.redirectSender.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        Receive_Port_Statement.checkReceivingStatement(timestamp, this, STATEMENT_NAME, this.portReference, this.receiveParameter, this.fromClause, this.redirectValue, this.redirectSender);
        if (this.redirectValue != null) {
            this.redirectValue.setUsedOnLeftHandSide();
        }
        if (this.redirectSender != null) {
            this.redirectSender.setUsedOnLeftHandSide();
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.redirectSender != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(129);
        if (this.redirectValue != null) {
            return result;
        }
        result.add(219);
        if (this.fromClause != null) {
            return result;
        }
        result.add(54);
        if (this.receiveParameter != null) {
            return result;
        }
        result.add(251);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.portReference != null) {
            this.portReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference.getLocation());
        }
        if (this.receiveParameter != null) {
            this.receiveParameter.updateSyntax(reparser, false);
            reparser.updateLocation(this.receiveParameter.getLocation());
        }
        if (this.fromClause != null) {
            this.fromClause.updateSyntax(reparser, false);
            reparser.updateLocation(this.fromClause.getLocation());
        }
        if (this.redirectValue != null) {
            this.redirectValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectValue.getLocation());
        }
        if (this.redirectSender != null) {
            this.redirectSender.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectSender.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.portReference != null) {
            this.portReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.receiveParameter != null) {
            this.receiveParameter.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.fromClause != null) {
            this.fromClause.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectValue != null) {
            this.redirectValue.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectSender != null) {
            this.redirectSender.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.portReference != null && !this.portReference.accept(v)) {
            return false;
        }
        if (this.receiveParameter != null && !this.receiveParameter.accept(v)) {
            return false;
        }
        if (this.fromClause != null && !this.fromClause.accept(v)) {
            return false;
        }
        if (this.redirectValue != null && !this.redirectValue.accept(v)) {
            return false;
        }
        return this.redirectSender == null || this.redirectSender.accept(v);
    }
}

