/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IIdentifierContainer;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErroneousAttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErroneousDescriptor;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErroneousValues;
import org.eclipse.titan.designer.AST.TTCN3.attributes.FieldErr_Type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifier;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class ErroneousAttributes
implements IIdentifierContainer,
IVisitableNode {
    private final IType type;
    private List<ErroneousAttributeSpecification> errAttrSpecs = null;
    private List<FieldErr_Type> fieldArray = null;
    private ErroneousDescriptor erroneousDescriptorTree = null;

    public ErroneousAttributes(IType type) {
        this.type = type;
    }

    public void addSpecification(ErroneousAttributeSpecification errAttrSpec) {
        if (this.errAttrSpecs == null) {
            this.errAttrSpecs = new ArrayList<ErroneousAttributeSpecification>(1);
        }
        this.errAttrSpecs.add(errAttrSpec);
    }

    public void addFieldErr(Qualifier qualifier, ErroneousAttributeSpecification errAttrSpec, List<Integer> subrefsArray, List<IType> typeArray) {
        if (qualifier == null || errAttrSpec == null || subrefsArray == null || typeArray == null) {
            ErrorReporter.INTERNAL_ERROR();
        }
        if (this.fieldArray == null) {
            this.fieldArray = new ArrayList<FieldErr_Type>();
        }
        this.fieldArray.add(new FieldErr_Type(qualifier, errAttrSpec, subrefsArray, typeArray));
    }

    private ErroneousDescriptor buildErroneousDescriptorTree(CompilationTimeStamp timestamp, List<FieldErr_Type> fldArray, int level) {
        ErroneousDescriptor erroneousDescr = new ErroneousDescriptor();
        Qualifier omitBeforeQualifier = null;
        Qualifier omitAfterQualifier = null;
        HashMap embeddedFieldArrayMap = new HashMap();
        block14: for (FieldErr_Type actualFieldErr : fldArray) {
            String message;
            if (actualFieldErr.subrefsArray.size() <= level) {
                ErrorReporter.INTERNAL_ERROR();
                return erroneousDescr;
            }
            int fieldIndex = actualFieldErr.subrefsArray.get(level);
            IType fieldType = actualFieldErr.typeArray.get(level);
            if (omitBeforeQualifier != null && erroneousDescr.omitBefore != -1 && erroneousDescr.omitBefore > fieldIndex) {
                message = MessageFormat.format("Field `{0}'' cannot be referenced because all fields before field `{1}'' have been omitted", actualFieldErr.qualifier.getDisplayName(), omitBeforeQualifier.getDisplayName());
                actualFieldErr.qualifier.getLocation().reportSemanticError(message);
                continue;
            }
            if (omitAfterQualifier != null && erroneousDescr.omitAfter != -1 && erroneousDescr.omitAfter < fieldIndex) {
                message = MessageFormat.format("Field `{0}'' cannot be referenced because all fields after field `{1}'' have been omitted", actualFieldErr.qualifier.getDisplayName(), omitAfterQualifier.getDisplayName());
                actualFieldErr.qualifier.getLocation().reportSemanticError(message);
                continue;
            }
            ErroneousAttributeSpecification.Indicator_Type actIndicator = actualFieldErr.errAttrSpec.getIndicator();
            boolean isOmit = actualFieldErr.errAttrSpec.isOmit();
            if (actualFieldErr.subrefsArray.size() == level + 1) {
                Object message2;
                if (actualFieldErr.typeArray.size() != level + 1) {
                    ErrorReporter.INTERNAL_ERROR();
                    return erroneousDescr;
                }
                if (fieldType.getTypetype() == IType.Type_type.TYPE_ASN1_SET && isOmit && actIndicator != ErroneousAttributeSpecification.Indicator_Type.Value_Indicator) {
                    String message3 = MessageFormat.format("Cannot omit all fields {0} `{1}'' which is a field of an ASN.1 SET type. The order of fields in ASN.1 SET types changes depending on tagging (see X.690 9.3). Fields can be omitted individually, independently of the field order which depends on tagging", actIndicator.getDisplayName(), actualFieldErr.qualifier.getDisplayName());
                    actualFieldErr.qualifier.getLocation().reportSemanticError(message3);
                    continue;
                }
                switch (fieldType.getTypetypeTtcn3()) {
                    case TYPE_TTCN3_CHOICE: {
                        if (actIndicator == ErroneousAttributeSpecification.Indicator_Type.Value_Indicator) break;
                        String message4 = MessageFormat.format("Indicator `{0}'' cannot be used with reference `{1}'' which points to a field of a union type", actIndicator.getDisplayName(), actualFieldErr.qualifier.getDisplayName());
                        actualFieldErr.qualifier.getLocation().reportSemanticError(message4);
                        continue block14;
                    }
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: {
                        if (isOmit && actIndicator == ErroneousAttributeSpecification.Indicator_Type.After_Indicator) {
                            int lastFieldIndex;
                            switch (fieldType.getTypetype()) {
                                case TYPE_ASN1_SEQUENCE: {
                                    lastFieldIndex = ((ASN1_Sequence_Type)fieldType).getNofComponents(timestamp) - 1;
                                    break;
                                }
                                case TYPE_ASN1_SET: {
                                    lastFieldIndex = ((ASN1_Set_Type)fieldType).getNofComponents(timestamp) - 1;
                                    break;
                                }
                                default: {
                                    lastFieldIndex = ((TTCN3_Set_Seq_Choice_BaseType)fieldType).getNofComponents() - 1;
                                }
                            }
                            if (fieldIndex == lastFieldIndex) {
                                message2 = MessageFormat.format("There is nothing to omit after the last field ({0}) of a record/set type", actualFieldErr.qualifier.getDisplayName());
                                actualFieldErr.qualifier.getLocation().reportSemanticError((String)message2);
                                continue block14;
                            }
                        }
                    }
                    case TYPE_SEQUENCE_OF: 
                    case TYPE_SET_OF: {
                        if (!isOmit || actIndicator != ErroneousAttributeSpecification.Indicator_Type.Before_Indicator || fieldIndex != 0) break;
                        actualFieldErr.qualifier.getLocation().reportSemanticError(MessageFormat.format("There is nothing to omit before the first field ({0})", actualFieldErr.qualifier.getDisplayName()));
                        continue block14;
                    }
                }
                if (erroneousDescr.valuesMap.containsKey(fieldIndex)) {
                    ErroneousValues evs = erroneousDescr.valuesMap.get(fieldIndex);
                    if (evs.before != null && actIndicator == ErroneousAttributeSpecification.Indicator_Type.Before_Indicator || evs.value != null && actIndicator == ErroneousAttributeSpecification.Indicator_Type.Value_Indicator || evs.after != null && actIndicator == ErroneousAttributeSpecification.Indicator_Type.After_Indicator) {
                        actualFieldErr.qualifier.getLocation().reportSemanticError(MessageFormat.format("Duplicate reference to field `{0}'' with indicator `{1}''", actualFieldErr.qualifier.getDisplayName(), actIndicator.getDisplayName()));
                        continue;
                    }
                }
                if (actIndicator == ErroneousAttributeSpecification.Indicator_Type.Value_Indicator && embeddedFieldArrayMap.containsKey(fieldIndex)) {
                    String message5 = MessageFormat.format("Reference to field `{0}'' with indicator `value'' would invalidate previously specified erroneous data", actualFieldErr.qualifier.getDisplayName());
                    actualFieldErr.qualifier.getLocation().reportSemanticError(message5);
                    continue;
                }
                if (actIndicator == ErroneousAttributeSpecification.Indicator_Type.Before_Indicator && isOmit) {
                    if (omitBeforeQualifier != null && erroneousDescr.omitBefore != -1) {
                        String message6 = MessageFormat.format("Duplicate rule for omitting all fields before the specified field. Used on field `{0}'' but previously already used on field `{1}''", actualFieldErr.qualifier.getDisplayName(), omitBeforeQualifier.getDisplayName());
                        actualFieldErr.qualifier.getLocation().reportSemanticError(message6);
                        continue;
                    }
                    boolean isInvalid = false;
                    for (Integer idx : erroneousDescr.valuesMap.keySet()) {
                        if (idx >= fieldIndex) continue;
                        isInvalid = true;
                        break;
                    }
                    if (!isInvalid) {
                        for (Integer idx : embeddedFieldArrayMap.keySet()) {
                            if (idx >= fieldIndex) continue;
                            isInvalid = true;
                            break;
                        }
                    }
                    if (isInvalid) {
                        message2 = MessageFormat.format("Omitting fields before field `{0}'' would invalidate previously specified erroneous data", actualFieldErr.qualifier.getDisplayName());
                        actualFieldErr.qualifier.getLocation().reportSemanticError((String)message2);
                        continue;
                    }
                    omitBeforeQualifier = actualFieldErr.qualifier;
                    erroneousDescr.omitBefore = fieldIndex;
                    erroneousDescr.omitBeforeName = omitBeforeQualifier.getDisplayName();
                    continue;
                }
                if (actIndicator == ErroneousAttributeSpecification.Indicator_Type.After_Indicator && isOmit) {
                    if (omitAfterQualifier != null && erroneousDescr.omitAfter != -1) {
                        String message7 = MessageFormat.format("Duplicate rule for omitting all fields after the specified field. Used on field `{0}'' but previously already used on field `{1}''", actualFieldErr.qualifier.getDisplayName(), omitAfterQualifier.getDisplayName());
                        actualFieldErr.qualifier.getLocation().reportSemanticError(message7);
                        continue;
                    }
                    boolean isInvalid = false;
                    for (Integer idx : erroneousDescr.valuesMap.keySet()) {
                        if (idx <= fieldIndex) continue;
                        isInvalid = true;
                        break;
                    }
                    if (!isInvalid) {
                        for (Integer idx : embeddedFieldArrayMap.keySet()) {
                            if (idx <= fieldIndex) continue;
                            isInvalid = true;
                            break;
                        }
                    }
                    if (isInvalid) {
                        message2 = MessageFormat.format("Omitting fields after field `{0}'' would invalidate previously specified erroneous data", actualFieldErr.qualifier.getDisplayName());
                        actualFieldErr.qualifier.getLocation().reportSemanticError((String)message2);
                        continue;
                    }
                    omitAfterQualifier = actualFieldErr.qualifier;
                    erroneousDescr.omitAfter = fieldIndex;
                    erroneousDescr.omitAfterName = omitAfterQualifier.getDisplayName();
                    continue;
                }
                boolean hasKey = erroneousDescr.valuesMap.containsKey(fieldIndex);
                ErroneousValues evs = hasKey ? erroneousDescr.valuesMap.get(fieldIndex) : new ErroneousValues(actualFieldErr.qualifier.getDisplayName());
                switch (actIndicator) {
                    case Before_Indicator: {
                        evs.before = actualFieldErr.errAttrSpec;
                        break;
                    }
                    case Value_Indicator: {
                        evs.value = actualFieldErr.errAttrSpec;
                        break;
                    }
                    case After_Indicator: {
                        evs.after = actualFieldErr.errAttrSpec;
                        break;
                    }
                    default: {
                        ErrorReporter.INTERNAL_ERROR();
                    }
                }
                if (hasKey) continue;
                erroneousDescr.valuesMap.put(fieldIndex, evs);
                continue;
            }
            if (erroneousDescr.valuesMap.containsKey(fieldIndex) && erroneousDescr.valuesMap.get((Object)Integer.valueOf((int)fieldIndex)).value != null) {
                String message8 = MessageFormat.format("Field `{0}'' is embedded into a field which was previously overwritten or omitted", actualFieldErr.qualifier.getDisplayName());
                actualFieldErr.qualifier.getLocation().reportSemanticError(message8);
                continue;
            }
            boolean hasIndex = embeddedFieldArrayMap.containsKey(fieldIndex);
            List<FieldErr_Type> embeddedFieldArray = hasIndex ? (List)embeddedFieldArrayMap.get(fieldIndex) : new ArrayList(1);
            embeddedFieldArray.add(actualFieldErr);
            if (hasIndex) continue;
            embeddedFieldArrayMap.put(fieldIndex, embeddedFieldArray);
        }
        for (Integer idx : embeddedFieldArrayMap.keySet()) {
            erroneousDescr.descriptorMap.put(idx, this.buildErroneousDescriptorTree(timestamp, (List)embeddedFieldArrayMap.get(idx), level + 1));
        }
        return erroneousDescr;
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.errAttrSpecs == null || this.fieldArray == null || this.type == null) {
            return;
        }
        this.erroneousDescriptorTree = this.buildErroneousDescriptorTree(timestamp, this.fieldArray, 0);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.errAttrSpecs != null) {
            for (ErroneousAttributeSpecification eas : this.errAttrSpecs) {
                eas.findReferences(referenceFinder, foundIdentifiers);
            }
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.errAttrSpecs != null) {
            for (ErroneousAttributeSpecification eas : this.errAttrSpecs) {
                if (eas.accept(v)) continue;
                return false;
            }
        }
        return v.leave(this) != 2;
    }
}

