/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IIdentifierContainer;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ErroneousAttributeSpecification
implements ILocateableNode,
IIncrementallyUpdateable,
IIdentifierContainer,
IVisitableNode {
    private final Indicator_Type indicator;
    private final boolean isRaw;
    private final TemplateInstance templateInst;
    private final boolean hasAllKeyword;
    private IType type = null;
    private IValue value = null;
    private Location location = NULL_Location.INSTANCE;

    public ErroneousAttributeSpecification(Indicator_Type indicator, boolean isRaw, TemplateInstance templateInst, boolean hasAllKeyword) {
        this.indicator = indicator;
        this.isRaw = isRaw;
        this.templateInst = templateInst;
        this.hasAllKeyword = hasAllKeyword;
    }

    public Indicator_Type getIndicator() {
        return this.indicator;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public boolean isOmit() {
        TTCN3Template templateBody = this.templateInst.getTemplateBody();
        switch (templateBody.getTemplatetype()) {
            case OMIT_VALUE: {
                return true;
            }
            case SPECIFIC_VALUE: {
                return ((SpecificValue_Template)templateBody).getSpecificValue().getValuetype() == IValue.Value_type.OMIT_VALUE;
            }
        }
        return false;
    }

    public void check(CompilationTimeStamp timestamp, Scope scope) {
        this.templateInst.setMyScope(scope);
        if (this.isOmit()) {
            if (this.indicator == Indicator_Type.Before_Indicator || this.indicator == Indicator_Type.After_Indicator) {
                if (!this.hasAllKeyword) {
                    String message = MessageFormat.format("Keyword `all'' is expected after `omit'' when omitting all fields {0} the specified field", this.indicator.getDisplayName());
                    this.templateInst.getLocation().reportSemanticError(message);
                }
            } else if (this.hasAllKeyword) {
                this.templateInst.getLocation().reportSemanticError("Unexpected `all' keyword after `omit' when omitting one field");
            }
            this.type = null;
            return;
        }
        if (this.hasAllKeyword) {
            this.templateInst.getLocation().reportSemanticError("Unexpected `all' keyword after the in-line template");
        }
        this.type = this.templateInst.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        if (this.type == null) {
            this.templateInst.getTemplateBody().setLoweridToReference(timestamp);
            this.type = this.templateInst.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        }
        if (this.type == null) {
            this.templateInst.getLocation().reportSemanticError("Cannot determine the type of the in-line template");
            return;
        }
        this.type.check(timestamp);
        IType typeLast = this.type.getTypeRefdLast(timestamp);
        if (typeLast == null || typeLast.getIsErroneous(timestamp)) {
            this.type = null;
            return;
        }
        if (this.isRaw) {
            switch (typeLast.getTypetypeTtcn3()) {
                case TYPE_BITSTRING: 
                case TYPE_OCTETSTRING: 
                case TYPE_CHARSTRING: 
                case TYPE_UCHARSTRING: {
                    break;
                }
                default: {
                    this.templateInst.getLocation().reportSemanticError(MessageFormat.format("An in-line template of type `{0}'' cannot be used as a `raw'' erroneous value", typeLast.getTypename()));
                }
            }
        }
        if (this.templateInst.getDerivedReference() != null) {
            this.templateInst.getLocation().reportSemanticError("Reference to a constant value was expected instead of an in-line modified template");
            this.type = null;
            return;
        }
        TTCN3Template templ = this.templateInst.getTemplateBody();
        if (!templ.isValue(timestamp)) {
            this.templateInst.getLocation().reportSemanticError("A specific value without matching symbols was expected");
            this.type = null;
            return;
        }
        this.value = templ.getValue();
        this.value.setMyGovernor(this.type);
        this.type.checkThisValueRef(timestamp, this.value);
        this.type.checkThisValue(timestamp, this.value, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, false, false, true, false, false));
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        this.templateInst.updateSyntax(reparser, false);
        reparser.updateLocation(this.templateInst.getLocation());
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInst != null) {
            this.templateInst.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.templateInst != null && !this.templateInst.accept(v)) {
            return false;
        }
        return v.leave(this) != 2;
    }

    public static enum Indicator_Type {
        Before_Indicator("before"),
        Value_Indicator("value"),
        After_Indicator("after"),
        Invalid_Indicator("<invalid>");

        private final String name;

        private Indicator_Type(String name) {
            this.name = name;
        }

        public String getDisplayName() {
            return this.name;
        }
    }
}

