/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.types.ExtensionAddition;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ExtensionAdditions
extends ASTNode {
    private final List<ExtensionAddition> extensionAdditions;

    public ExtensionAdditions() {
        this.extensionAdditions = new ArrayList<ExtensionAddition>();
    }

    public ExtensionAdditions(List<ExtensionAddition> extensionAdditions) {
        this.extensionAdditions = extensionAdditions;
        for (ExtensionAddition extensionAddition : extensionAdditions) {
            extensionAddition.setFullNameParent(this);
        }
    }

    public void addExtensionAddition(ExtensionAddition extensionAddition) {
        if (null != extensionAddition) {
            this.extensionAdditions.add(extensionAddition);
            extensionAddition.setFullNameParent(this);
        }
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        for (ExtensionAddition extensionAddition : this.extensionAdditions) {
            extensionAddition.setMyScope(scope);
        }
    }

    public int getNofComps() {
        int result = 0;
        for (ExtensionAddition extensionAddition : this.extensionAdditions) {
            result += extensionAddition.getNofComps();
        }
        return result;
    }

    public CompField getCompByIndex(int index) {
        int offset = index;
        for (int i = 0; i < this.extensionAdditions.size(); ++i) {
            int subSize = this.extensionAdditions.get(i).getNofComps();
            if (offset < subSize) {
                return this.extensionAdditions.get(i).getCompByIndex(offset);
            }
            offset -= subSize;
        }
        return null;
    }

    public boolean hasCompWithName(Identifier identifier) {
        for (ExtensionAddition extensionAddition : this.extensionAdditions) {
            if (!extensionAddition.hasCompWithName(identifier)) continue;
            return true;
        }
        return false;
    }

    public CompField getCompByName(Identifier identifier) {
        for (ExtensionAddition extensionAddition : this.extensionAdditions) {
            if (!extensionAddition.hasCompWithName(identifier)) continue;
            return extensionAddition.getCompByName(identifier);
        }
        return null;
    }

    public void trCompsof(CompilationTimeStamp timestamp, IReferenceChain referenceChain, boolean isSet) {
        for (ExtensionAddition extensionAddition : this.extensionAdditions) {
            extensionAddition.trCompsof(timestamp, referenceChain, isSet);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.extensionAdditions == null) {
            return;
        }
        for (ExtensionAddition ea : this.extensionAdditions) {
            ea.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.extensionAdditions != null) {
            for (ExtensionAddition ea : this.extensionAdditions) {
                if (ea.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

